set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8916689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4213',
      '44322042',
      '41123114',
      '32300423',
      '12011003',
      '00033302',
      NULL,
      '23241044',
      '14001020',
      '11331321',
      '03022121',
      NULL,
      '44234221',
      '04332420',
      NULL,
      NULL,
      NULL,
      '04122420',
      '02243423',
      '41014122',
      '13204431',
      '13213110',
      '20223024',
      NULL,
      '01000300',
      '24231044',
      '44331320',
      NULL,
      '22321433',
      '33302033',
      NULL,
      '24104113',
      '40431401',
      NULL,
      '43022020',
      NULL,
      '13402402',
      '34224401',
      '33432131',
      '42223001',
      '34102234',
      NULL,
      '10113024',
      NULL,
      '33304323',
      NULL,
      '',
      NULL,
      NULL,
      '2041143',
      1,
      0,
      1,
      NULL,
      '212022',
      NULL,
      ' 5- 2-1977',
      ' 5-29-1980',
      32,
      NULL,
      8,
      NULL,
      26.868042,
      17,
      16.553566,
      4,
      7,
      2,
      15.640464,
      4,
      15.987735,
      11,
      17,
      NULL,
      NULL,
      7.105450,
      27.810145,
      NULL,
      9,
      12.718508,
      NULL,
      9.830905,
      NULL,
      NULL,
      19.569486,
      37.049810,
      NULL,
      52.568480,
      92.959197,
      ' 7- 6-1987',
      NULL,
      18.594838,
      NULL,
      13,
      50.796483,
      37,
      ' 5- 8-1982',
      NULL,
      NULL,
      3.352266,
      4.998680,
      NULL,
      NULL,
      NULL,
      NULL,
      3.327776,
      0.747068,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 7-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35,
      78.261443,
      23.285722,
      33.793958,
      57,
      115,
      56,
      53,
      76.711970,
      61.332106,
      50.821218,
      33.110635,
      ' 4- 7-1982',
      5,
      5,
      NULL,
      35.024980,
      28.733318,
      4,
      NULL,
      ' 9-24-1977',
      NULL,
      1,
      ' 9- 6-1997',
      7.793411,
      4.962956,
      3.217362,
      NULL,
      16.329054,
      0,
      NULL,
      1,
      NULL,
      61.443611,
      13.389890,
      0,
      1.141732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.923649,
      25.630136,
      1.128760,
      ' 6-29-1980',
      4,
      555.460253,
      '11-15-1978',
      7,
      7,
      0,
      80.218848,
      ' 7-28-1975',
      51,
      NULL,
      NULL,
      ' 5- 4-1982',
      NULL,
      NULL,
      NULL,
      7.711567,
      62,
      27,
      NULL,
      0.325099,
      108,
      51,
      43,
      35,
      13,
      3,
      69.482017,
      0.575730,
      1,
      NULL,
      1.158790,
      0,
      NULL,
      NULL,
      8.190848,
      NULL,
      NULL,
      2.713875,
      104.635933,
      NULL,
      1,
      52,
      1.886431,
      39,
      1.288327,
      0,
      0.026661,
      9.550291,
      0,
      NULL,
      47.220118,
      8,
      37.283070,
      11.743133,
      30,
      NULL,
      4,
      4,
      39.338943,
      NULL,
      1,
      0.964557,
      31,
      0.066102,
      21,
      6,
      51.708271,
      0.215912,
      1,
      32,
      13.477644,
      4,
      2,
      66.631680,
      NULL,
      7.375869,
      8,
      6,
      NULL,
      0.303974,
      NULL,
      2.876373,
      0,
      NULL,
      1,
      28,
      ' 2-20-1975',
      ' 5-22-1992',
      ' 2-23-1990',
      ' 8-21-1999',
      '10- 3-1983',
      '10-12-1987',
      ' 1-15-1996',
      NULL);
commit;
end;
/


