set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8916689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1304',
      '14242334',
      '03201240',
      NULL,
      '00203223',
      NULL,
      '00310341',
      '44020211',
      '34320202',
      '11444444',
      '04104014',
      '24244243',
      NULL,
      NULL,
      '30103232',
      '44042111',
      '11131233',
      '34200023',
      NULL,
      NULL,
      '04030111',
      '00344011',
      '31314014',
      NULL,
      '03443320',
      '23423301',
      '13421314',
      '22140310',
      '02024230',
      '03022432',
      '01411332',
      '30200141',
      '14033244',
      '02202023',
      '03303044',
      '14010312',
      '20043131',
      '21323404',
      '00413300',
      '11401042',
      '02011412',
      '41203024',
      '03244041',
      '12413231',
      '44444214',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      2.895020,
      10.892022,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      ' 8-19-1984',
      34.720904,
      NULL,
      NULL,
      17,
      21.978427,
      5,
      13,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      20.611656,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.965872,
      15,
      NULL,
      NULL,
      67.323089,
      3,
      NULL,
      NULL,
      21.864159,
      NULL,
      3.809375,
      NULL,
      55,
      ' 1-27-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-15-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.028917,
      NULL,
      3,
      22.590647,
      25,
      18,
      7,
      NULL,
      17.043107,
      NULL,
      ' 9-10-2001',
      15.149778,
      8,
      4,
      11.844919,
      NULL,
      NULL,
      NULL,
      2.921057,
      NULL,
      55.574822,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-29-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      ' 5-11-1987',
      1.549114,
      158,
      NULL,
      14,
      0,
      6,
      16,
      ' 6-18-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      13,
      94.326962,
      47.065879,
      NULL,
      26.148883,
      3.429894,
      1,
      1,
      NULL,
      83.771756,
      NULL,
      3,
      66.393824,
      0,
      3,
      176.480349,
      NULL,
      NULL,
      50,
      55,
      NULL,
      NULL,
      NULL,
      49,
      0,
      1,
      1.801802,
      0.883238,
      0.108473,
      1,
      59.272872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53.825430,
      1.596472,
      2.706244,
      66,
      10,
      5,
      NULL,
      NULL,
      28,
      NULL,
      NULL,
      2,
      17.887843,
      NULL,
      NULL,
      0,
      1,
      1.783869,
      NULL,
      NULL,
      ' 8- 6-1977',
      NULL,
      NULL,
      NULL,
      ' 3-18-1985',
      NULL,
      ' 4- 4-1996',
      NULL);
commit;
end;
/


