set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9639067';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0242',
      '12220332',
      '44231133',
      '03312000',
      '43040241',
      NULL,
      '40322430',
      '31044440',
      '14302143',
      '20114432',
      '33410221',
      '14222122',
      '03344234',
      '44124240',
      NULL,
      '22421102',
      '31132420',
      '40121314',
      '13310422',
      '40422301',
      NULL,
      NULL,
      '21022243',
      '33403340',
      NULL,
      '00141420',
      '42400021',
      '33310244',
      '00411403',
      '44310320',
      NULL,
      '40044141',
      '13404210',
      NULL,
      '40032424',
      NULL,
      '20342140',
      '13002412',
      '24100024',
      '44111231',
      '21131131',
      '03300441',
      '14030332',
      '42101444',
      '21310322',
      '233',
      '41',
      NULL,
      10,
      NULL,
      2,
      1.978438,
      NULL,
      NULL,
      '042213',
      4.620637,
      ' 5-16-1998',
      ' 0-12-1997',
      28.205745,
      75.991013,
      NULL,
      5,
      25,
      13,
      8,
      14.352993,
      21,
      10.537774,
      22,
      3,
      26,
      7.257899,
      NULL,
      19,
      5.913746,
      13,
      11,
      NULL,
      29.735372,
      NULL,
      17.997076,
      16,
      0,
      24,
      77,
      NULL,
      125,
      91,
      53.579729,
      ' 2-21-1995',
      8.377730,
      23,
      21,
      NULL,
      169.267363,
      77,
      ' 4- 8-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37.071589,
      NULL,
      16.260679,
      4.613549,
      NULL,
      6.915747,
      ' 7- 8-1992',
      0,
      0,
      157.953422,
      0,
      1.290121,
      68.603536,
      0.839889,
      1.064556,
      30,
      NULL,
      NULL,
      NULL,
      ' 7-28-2001',
      NULL,
      27.996447,
      68,
      12,
      34.249659,
      41.767540,
      30,
      57,
      18,
      21,
      30,
      61,
      ' 1-22-1994',
      NULL,
      NULL,
      NULL,
      28,
      9,
      5,
      11.622946,
      ' 6- 0-1995',
      23.828337,
      11.676866,
      ' 1-27-1999',
      NULL,
      5,
      9,
      13.947602,
      3,
      5,
      1,
      NULL,
      0.807319,
      14,
      9,
      0.762338,
      2,
      NULL,
      NULL,
      14.266338,
      1.563635,
      3.021667,
      ' 1- 4-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      37.328095,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      31.403232,
      ' 8- 7-1982',
      39.965305,
      ' 5-13-2002',
      15.422845,
      NULL,
      ' 0-11-1989',
      11,
      76,
      ' 5-14-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      ' 1-27-1986',
      3.844160,
      6.182009,
      4.215840,
      ' 5-25-1984',
      0.117935,
      54,
      ' 3-24-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


