set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04002431',
      '03420114',
      NULL,
      '44444042',
      '42401202',
      NULL,
      NULL,
      NULL,
      '10324112',
      '21204230',
      '01244142',
      '44301041',
      '11321320',
      '42023100',
      '40022002',
      '12143142',
      '03341142',
      NULL,
      '40421221',
      '31121044',
      NULL,
      '40423222',
      '03022012',
      '22204314',
      '22420420',
      '44214210',
      '34221021',
      '42431224',
      '01432420',
      '11433214',
      '32113002',
      '04201340',
      '10032224',
      '03332202',
      '44224440',
      '10004424',
      NULL,
      '44343004',
      '02413343',
      '24022104',
      '00423220',
      NULL,
      '40434404',
      '04144020',
      '302',
      NULL,
      NULL,
      NULL,
      '0321324',
      3.482513,
      1,
      NULL,
      NULL,
      '330222',
      NULL,
      ' 2-29-1999',
      ' 7- 0-1976',
      48,
      NULL,
      16.152940,
      0.093089,
      NULL,
      25,
      61,
      4.121776,
      11,
      11,
      10.692434,
      NULL,
      20,
      9,
      18.064803,
      0.568265,
      28,
      21.617060,
      39,
      11.254697,
      64.825632,
      21.112977,
      72.018536,
      2,
      1.291295,
      70,
      219.730085,
      33.742636,
      NULL,
      NULL,
      144.003331,
      NULL,
      18.826479,
      40,
      28,
      16,
      166,
      NULL,
      ' 0-23-1988',
      NULL,
      NULL,
      NULL,
      5.566861,
      0,
      NULL,
      1,
      NULL,
      1.087005,
      0,
      0.099175,
      1,
      1,
      2.735905,
      2.895522,
      1,
      1.472165,
      0,
      1.392785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-15-1976',
      36.940769,
      10.608775,
      17,
      20.575025,
      NULL,
      NULL,
      ' 5-27-1980',
      1,
      1,
      89.631582,
      NULL,
      1,
      10,
      NULL,
      0,
      10,
      NULL,
      NULL,
      NULL,
      ' 0- 3-1998',
      31,
      NULL,
      51.853125,
      32,
      NULL,
      40.056986,
      72,
      6.816634,
      NULL,
      34.977886,
      29.331921,
      63,
      ' 6- 7-1981',
      8,
      NULL,
      NULL,
      26.762902,
      NULL,
      10,
      3.378260,
      ' 8-17-1985',
      0,
      8,
      ' 8- 5-1993',
      4.949248,
      12,
      1,
      5,
      11.106252,
      2.453669,
      1,
      12.481975,
      1.033166,
      22.321811,
      0,
      0,
      2,
      6.583202,
      6,
      0,
      1.661631,
      1,
      ' 1-12-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      82,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      '11-14-1980',
      29.706285,
      NULL,
      12.081079,
      2.197206,
      ' 1-14-1996',
      57.412005,
      NULL,
      ' 7-21-1993',
      4,
      1,
      ' 9-16-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      19,
      ' 9-21-1986',
      52.162294,
      38,
      12,
      ' 0-15-1983',
      0.930822,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


