set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      '0',
      '1',
      '2',
      '3',
      '2',
      '4',
      NULL,
      NULL,
      '2',
      '1',
      '0',
      NULL,
      '1',
      '0',
      '1',
      '0',
      '3',
      NULL,
      '0',
      NULL,
      '0',
      '4',
      '',
      '0',
      NULL,
      NULL,
      '3',
      NULL,
      '1',
      '4',
      '',
      '',
      '3',
      '1',
      '3',
      '2',
      '0',
      '1',
      '2',
      NULL,
      NULL,
      '3',
      '1',
      '023',
      '32002024',
      NULL,
      NULL,
      '0042302',
      NULL,
      0,
      NULL,
      NULL,
      '201012',
      1,
      ' 1-17-1993',
      ' 4-21-1998',
      249,
      54.527493,
      23.981086,
      24,
      24,
      12,
      38,
      3.938770,
      15.761757,
      18.360999,
      44.708806,
      1.268078,
      35.388694,
      5,
      11.711524,
      4,
      23,
      16.427174,
      74,
      15.832968,
      8,
      NULL,
      78,
      10.517822,
      0,
      NULL,
      101.142141,
      16.235047,
      NULL,
      122,
      NULL,
      ' 3-14-1983',
      55,
      NULL,
      NULL,
      2.729802,
      74.172705,
      NULL,
      ' 1-24-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      NULL,
      7,
      1,
      9,
      8.022522,
      ' 2-14-1974',
      0.705344,
      1,
      45,
      NULL,
      0,
      79.995136,
      NULL,
      1.329911,
      0.435922,
      NULL,
      NULL,
      NULL,
      ' 3-27-1990',
      46,
      92.759733,
      53,
      51.784094,
      21,
      100,
      38,
      70.527385,
      48,
      100,
      41,
      25.122768,
      NULL,
      4,
      14,
      3.982316,
      12,
      49,
      4,
      4.147112,
      ' 9- 8-1977',
      14,
      9.145020,
      ' 2-28-1993',
      5.117163,
      NULL,
      9.681853,
      17,
      20.526070,
      6,
      NULL,
      16.370045,
      1,
      94.540680,
      NULL,
      NULL,
      14.215061,
      7,
      0.580390,
      0,
      1,
      1.158243,
      ' 6-29-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      134,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      ' 3- 9-1983',
      NULL,
      ' 7-14-1978',
      1,
      2,
      ' 4- 4-1977',
      NULL,
      93.498288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      7.198708,
      ' 6-15-1985',
      32.119226,
      21.500421,
      NULL,
      NULL,
      2.474461,
      68.822654,
      ' 6- 6-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


