set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9784714';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      NULL,
      '3',
      NULL,
      '3',
      '2',
      '2',
      '0',
      NULL,
      '2',
      '1',
      NULL,
      '1',
      NULL,
      '0',
      '4',
      '0',
      '4',
      '1',
      NULL,
      '1',
      '3',
      '3',
      '',
      '4',
      '',
      '2',
      '1',
      NULL,
      '2',
      '2',
      '',
      '',
      NULL,
      '3',
      '0',
      '3',
      NULL,
      '4',
      NULL,
      '2',
      '2',
      '2',
      '1',
      '133',
      '42222014',
      NULL,
      24.305924,
      '1122213',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.195613,
      NULL,
      ' 1- 4-1988',
      5.491896,
      208,
      5.560777,
      12.483943,
      12.981144,
      3.952648,
      56.616639,
      10.791980,
      NULL,
      8,
      11.038498,
      9.402545,
      NULL,
      3.447067,
      25.832908,
      2,
      NULL,
      10,
      28.821387,
      1,
      11.900477,
      NULL,
      71,
      9,
      NULL,
      47,
      64.070189,
      6.704975,
      111,
      122.031115,
      79.482633,
      ' 9- 5-1979',
      47.073745,
      4,
      NULL,
      15,
      94.993322,
      128,
      '10-20-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      75.756874,
      85,
      1,
      47.856616,
      1,
      ' 6-19-2001',
      1.330060,
      1.797153,
      169,
      1,
      0,
      46.267336,
      1,
      1.421122,
      24.467876,
      NULL,
      NULL,
      NULL,
      ' 7-19-1975',
      6.612439,
      85.026457,
      38,
      64.837230,
      84,
      NULL,
      13,
      NULL,
      2.054699,
      97,
      61.265589,
      NULL,
      NULL,
      13,
      7,
      8,
      NULL,
      60.038577,
      32.641800,
      6.076001,
      ' 1- 8-2001',
      10,
      4.551777,
      NULL,
      4.182858,
      1.461437,
      2,
      10.597457,
      NULL,
      NULL,
      1.507129,
      6.352680,
      NULL,
      NULL,
      0.401048,
      1,
      4.569662,
      7.453558,
      4,
      6.333882,
      1.725494,
      1.292206,
      ' 5-25-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.050559,
      ' 2- 7-1992',
      40.415410,
      ' 6-28-1980',
      6,
      12,
      '11-11-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3.230333,
      ' 6-10-1996',
      55,
      NULL,
      18.694351,
      ' 4-23-1999',
      5,
      NULL,
      '11-13-1988',
      3,
      11,
      8,
      NULL,
      ' 5-27-1995',
      45,
      0.089456,
      82,
      '10-22-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


