set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7127190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '3',
      '3',
      '0',
      '1',
      '0',
      '1',
      NULL,
      NULL,
      '2',
      '1',
      '4',
      NULL,
      '0',
      '0',
      NULL,
      '3',
      '0',
      '3',
      '0',
      '1',
      '2',
      '3',
      '',
      '0',
      '',
      '3',
      '1',
      '0',
      '4',
      '1',
      '',
      '',
      '2',
      NULL,
      '1',
      '0',
      '2',
      '4',
      '3',
      NULL,
      NULL,
      '1',
      '1',
      '242',
      '33341110',
      32.475448,
      48,
      '0031030',
      3,
      1,
      NULL,
      0,
      '314444',
      0,
      NULL,
      ' 9- 7-1992',
      26.204586,
      258.031983,
      33,
      NULL,
      1.663347,
      7,
      86,
      NULL,
      8.257188,
      7.531901,
      16.968112,
      0.279254,
      4,
      14,
      1.252605,
      8,
      9,
      3.949557,
      19,
      1,
      NULL,
      9,
      19.878771,
      NULL,
      1.206266,
      NULL,
      132.982682,
      5,
      85,
      131,
      NULL,
      ' 1-16-1998',
      6,
      1,
      25,
      8.147546,
      40,
      32.839715,
      ' 8- 1-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.497297,
      15.575436,
      3.174325,
      NULL,
      6.749928,
      0.893861,
      ' 4- 0-1986',
      1,
      1.877031,
      128,
      0,
      1.375238,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      ' 5-26-1998',
      6,
      NULL,
      42,
      40,
      39.901350,
      54.108740,
      17.231559,
      NULL,
      69.204133,
      NULL,
      28,
      8,
      NULL,
      NULL,
      3.321307,
      19.472024,
      NULL,
      3,
      0.129302,
      0,
      ' 3-14-1988',
      NULL,
      7.165020,
      '11- 4-1996',
      12,
      11,
      11.309468,
      8.339154,
      4,
      1.456342,
      1.745618,
      5.822942,
      1.844744,
      NULL,
      1,
      1,
      2.406870,
      5,
      NULL,
      1,
      NULL,
      1.565113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      16,
      '11- 9-1984',
      NULL,
      NULL,
      NULL,
      11,
      '10-20-1979',
      2,
      ' 4-11-1996',
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      8,
      NULL,
      9.596470,
      5,
      22.066066,
      NULL,
      1.319132,
      9.932097,
      ' 0-19-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


