set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9311844';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      '1',
      '2',
      '1',
      NULL,
      NULL,
      '3',
      '2',
      '1',
      NULL,
      '3',
      '3',
      '0',
      NULL,
      '1',
      '2',
      '4',
      '4',
      NULL,
      '4',
      NULL,
      '0',
      '3',
      '',
      '4',
      '',
      '2',
      '3',
      '1',
      '3',
      '4',
      '',
      '',
      '4',
      '3',
      NULL,
      '4',
      NULL,
      '0',
      NULL,
      '0',
      '4',
      '1',
      '3',
      '040',
      '24433204',
      85,
      53.997928,
      '2013414',
      2.309894,
      1,
      1,
      1,
      NULL,
      2.684269,
      ' 2- 5-1983',
      ' 9- 8-1986',
      NULL,
      NULL,
      NULL,
      12,
      16.261240,
      9.425239,
      58,
      9,
      12,
      9,
      NULL,
      8,
      15.604153,
      NULL,
      NULL,
      13.367811,
      12,
      17.734039,
      53.583346,
      11.973100,
      29,
      NULL,
      45.606097,
      10.452311,
      0,
      19,
      123.360365,
      78,
      112.528746,
      NULL,
      167.223650,
      NULL,
      NULL,
      NULL,
      25.783479,
      8,
      43,
      143.474574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.988872,
      5,
      4,
      NULL,
      1,
      0.472030,
      ' 5-25-1984',
      0,
      3,
      NULL,
      1,
      NULL,
      49.696267,
      1.683799,
      1.862341,
      42.735326,
      NULL,
      NULL,
      NULL,
      NULL,
      48,
      45,
      6,
      73,
      62,
      NULL,
      35,
      NULL,
      NULL,
      23,
      0.098540,
      36,
      NULL,
      14.942015,
      5.954775,
      11.773262,
      NULL,
      50,
      NULL,
      9.911802,
      NULL,
      5.231735,
      1,
      ' 5-17-1997',
      4.608805,
      0.658902,
      NULL,
      NULL,
      19,
      6,
      1,
      8,
      NULL,
      61.084135,
      2.976017,
      0,
      9,
      16,
      7,
      0,
      0.945070,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36.748020,
      NULL,
      ' 0-29-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-14-1978',
      14.486120,
      ' 0-14-1986',
      2.029354,
      16,
      NULL,
      68,
      NULL,
      '11- 5-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      ' 6-14-1990',
      17,
      17,
      NULL,
      '11-26-1987',
      0.503111,
      111,
      ' 3-18-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


