set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9503544';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '44324110',
      '31143201',
      NULL,
      '00413242',
      '13212112',
      '21222132',
      '30141443',
      '41401424',
      NULL,
      '12133240',
      '13203141',
      NULL,
      '41330141',
      '24422444',
      '21041040',
      '20431040',
      '24030042',
      '44434334',
      '14441212',
      NULL,
      '14304402',
      '41111403',
      NULL,
      '04102431',
      '10010113',
      '20232004',
      '30242234',
      '21311021',
      '31334021',
      '12310203',
      '40310432',
      '12341110',
      '24042321',
      '24100143',
      NULL,
      NULL,
      NULL,
      '02204023',
      '20122314',
      '22303142',
      '02341234',
      NULL,
      '21043300',
      '23131211',
      '143',
      NULL,
      NULL,
      NULL,
      NULL,
      3.532899,
      1.555960,
      NULL,
      NULL,
      '304403',
      4,
      ' 7-16-1976',
      ' 3-23-2002',
      NULL,
      NULL,
      3,
      0.706646,
      NULL,
      8.725330,
      1,
      6.005011,
      11.354285,
      4,
      28.430149,
      13.008581,
      7.508679,
      7.851216,
      4.944368,
      1.977321,
      0,
      2,
      12,
      8.883085,
      NULL,
      9.442346,
      NULL,
      NULL,
      1.312618,
      71,
      19,
      11.445220,
      NULL,
      NULL,
      7.823661,
      ' 7- 9-1999',
      27.938342,
      3,
      23,
      13,
      95,
      80.698441,
      NULL,
      NULL,
      14,
      NULL,
      18.419822,
      0.792409,
      95,
      NULL,
      109,
      1,
      0.187650,
      0,
      NULL,
      0.590363,
      52.413745,
      0,
      1.266400,
      39,
      0.058209,
      1.276468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-27-1980',
      27,
      70.299210,
      NULL,
      NULL,
      59.457397,
      NULL,
      '10-20-1997',
      1,
      1.413425,
      85,
      1.047552,
      0,
      NULL,
      15.118870,
      2,
      12,
      NULL,
      NULL,
      NULL,
      ' 5-15-2002',
      8.357125,
      NULL,
      23,
      27,
      31,
      9,
      23.302885,
      31.816476,
      11.728574,
      5,
      NULL,
      2.224313,
      ' 2-19-1990',
      14,
      6,
      8.114595,
      42.279232,
      27,
      NULL,
      9.650676,
      ' 7-10-1990',
      0,
      4.593774,
      NULL,
      5,
      13,
      14.944405,
      18.975347,
      21,
      NULL,
      0,
      NULL,
      1.315719,
      25.663868,
      2,
      9.036097,
      5,
      22,
      NULL,
      15.508715,
      0.694145,
      1.378301,
      '11-28-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      9,
      ' 6-26-2000',
      6,
      7.791371,
      '10-27-1992',
      11.844567,
      52.295761,
      ' 4-11-1985',
      4.214787,
      7.396594,
      '11- 4-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      ' 5-12-1980',
      24,
      7.270361,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


