set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9767251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '0',
      '3',
      '2',
      '1',
      '0',
      '0',
      '1',
      '3',
      '0',
      '1',
      '4',
      '2',
      '4',
      NULL,
      '4',
      '1',
      '4',
      NULL,
      '1',
      '4',
      '0',
      '3',
      '',
      NULL,
      '',
      NULL,
      '4',
      '1',
      '0',
      '4',
      '',
      NULL,
      '1',
      NULL,
      '3',
      '0',
      '1',
      '3',
      NULL,
      '2',
      '4',
      NULL,
      '4',
      '313',
      '20004014',
      NULL,
      37.419712,
      '4314440',
      3,
      0.834116,
      2,
      NULL,
      NULL,
      1.563338,
      ' 5- 2-1980',
      ' 0- 9-1992',
      2,
      202,
      0.833992,
      1.623425,
      NULL,
      NULL,
      81.780850,
      14,
      10,
      12.270142,
      17,
      11,
      NULL,
      7,
      12.181352,
      12.859149,
      7,
      NULL,
      78.316684,
      NULL,
      53,
      15,
      86.460111,
      2.844688,
      0.944988,
      82,
      16,
      NULL,
      103,
      74,
      NULL,
      NULL,
      NULL,
      6.582082,
      8,
      18,
      1.624332,
      65.475393,
      '11- 9-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      5.022602,
      14,
      4,
      NULL,
      ' 6- 5-1989',
      NULL,
      0,
      18,
      1,
      NULL,
      113.857885,
      7,
      0.666991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      23.280761,
      2,
      56,
      25.438397,
      NULL,
      6,
      NULL,
      37,
      50.964895,
      NULL,
      1,
      ' 1- 7-1991',
      2.450502,
      10,
      15.885184,
      37.143404,
      9,
      101.202817,
      8,
      ' 8-20-1978',
      5,
      3,
      ' 3-16-2002',
      8,
      NULL,
      4,
      13.613069,
      13,
      5,
      NULL,
      3,
      1,
      33.668984,
      NULL,
      1.543452,
      NULL,
      25.771685,
      NULL,
      5.135646,
      0,
      1.984955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      171.296958,
      NULL,
      ' 5- 1-1996',
      NULL,
      NULL,
      NULL,
      12,
      ' 9- 0-1981',
      42.294014,
      ' 8-21-1983',
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4.390818,
      '10- 6-1993',
      44.585605,
      11,
      NULL,
      ' 1-26-1983',
      0,
      57,
      ' 7-23-1988',
      2,
      12.929650,
      12,
      34.539572,
      ' 5-10-1989',
      33.459654,
      NULL,
      8.962153,
      ' 1-22-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


