set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9767251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      '0',
      '2',
      '4',
      '0',
      '2',
      '2',
      '4',
      NULL,
      '0',
      '1',
      '3',
      '0',
      '1',
      '4',
      '1',
      '4',
      '2',
      '4',
      '1',
      NULL,
      '2',
      NULL,
      '',
      '4',
      '',
      '4',
      '3',
      '4',
      '3',
      '0',
      '',
      NULL,
      '2',
      NULL,
      '3',
      '4',
      '0',
      NULL,
      '4',
      NULL,
      '0',
      '4',
      NULL,
      '343',
      '01234222',
      48,
      62,
      NULL,
      NULL,
      27,
      2,
      NULL,
      '330232',
      5,
      ' 3-21-2003',
      ' 1-18-1995',
      2.620402,
      150,
      NULL,
      8.225695,
      11.449729,
      14,
      NULL,
      12,
      6,
      14.091712,
      19.193685,
      2,
      33.128530,
      NULL,
      22.402399,
      18.059780,
      4.050635,
      0,
      64.195981,
      17.850813,
      NULL,
      NULL,
      65,
      0,
      NULL,
      5.552754,
      142,
      81,
      NULL,
      111,
      NULL,
      '11- 6-1985',
      18,
      70.947995,
      12,
      0,
      188.727099,
      140.036201,
      ' 4-29-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      73,
      NULL,
      10,
      0.837109,
      14.034611,
      0,
      ' 8-10-2002',
      1.517004,
      NULL,
      157,
      NULL,
      1.136529,
      114.535912,
      0.093401,
      0.780852,
      1.373764,
      NULL,
      NULL,
      NULL,
      ' 6- 1-1982',
      86,
      55.641735,
      NULL,
      NULL,
      9.440283,
      24,
      34,
      69.579097,
      72.206777,
      NULL,
      85,
      93,
      ' 9-28-1978',
      30,
      0.709893,
      12.728761,
      62.956880,
      NULL,
      104,
      10.473011,
      '11-29-1980',
      23,
      4.450772,
      ' 3-25-1997',
      NULL,
      12,
      3,
      4.638241,
      13.846684,
      7,
      2,
      16,
      0.016544,
      NULL,
      NULL,
      0,
      4,
      15,
      NULL,
      1.471310,
      NULL,
      1.485462,
      ' 9- 2-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      141,
      NULL,
      ' 8-16-1986',
      NULL,
      NULL,
      NULL,
      29.975087,
      ' 2-13-1976',
      4,
      ' 2-11-1988',
      6.826552,
      7.613256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.189171,
      NULL,
      NULL,
      9,
      10.840458,
      ' 6- 6-1988',
      1.005559,
      18.203745,
      NULL,
      NULL,
      22,
      NULL,
      45,
      ' 1-19-2003',
      70.309238,
      0,
      73,
      ' 1- 7-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


