set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9518951';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2331',
      '11034002',
      '03212114',
      NULL,
      NULL,
      '30423000',
      '24022031',
      '10110204',
      NULL,
      NULL,
      NULL,
      '22301040',
      '00224041',
      '32101022',
      '40203304',
      NULL,
      '42114314',
      '00112344',
      '13122311',
      NULL,
      NULL,
      '13011013',
      '01231020',
      '30133030',
      '31331344',
      '43410103',
      '13222201',
      '10424033',
      '10020431',
      '33414241',
      '32232000',
      NULL,
      '32133244',
      '43110312',
      '22124144',
      NULL,
      '21222444',
      '11322104',
      '34311212',
      '03423401',
      NULL,
      '04044410',
      '22120104',
      '42143420',
      '02302323',
      '130',
      NULL,
      NULL,
      NULL,
      NULL,
      2.144555,
      NULL,
      2,
      NULL,
      NULL,
      5.604514,
      ' 6-29-1989',
      ' 1-19-1975',
      99,
      NULL,
      NULL,
      8.385153,
      9.196881,
      22.546724,
      NULL,
      NULL,
      6.180769,
      0,
      6.925206,
      10,
      NULL,
      5.576907,
      25.314380,
      6,
      33.650566,
      13,
      34,
      1.459966,
      42.001771,
      3,
      83.781654,
      NULL,
      1,
      80,
      30,
      29.498706,
      133.645477,
      4,
      127,
      ' 7-25-1992',
      24.668980,
      NULL,
      15,
      22.180257,
      59.803373,
      NULL,
      ' 8-29-1976',
      NULL,
      0.439399,
      0,
      0,
      0.854996,
      1.898038,
      1.963071,
      3,
      0.710660,
      0,
      NULL,
      1,
      0.214424,
      1.014953,
      0,
      NULL,
      1,
      3.862593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 3-1988',
      65.785357,
      NULL,
      31.293075,
      15,
      0.705327,
      2.871533,
      NULL,
      0.138895,
      0,
      132,
      1.387767,
      0,
      NULL,
      1.675212,
      1.598836,
      20.582839,
      NULL,
      NULL,
      NULL,
      ' 1-19-1979',
      40.560311,
      54,
      103,
      75,
      28,
      38.137012,
      78.493171,
      5.168622,
      72,
      30.068597,
      76.570283,
      9,
      NULL,
      2,
      23.387844,
      33.794448,
      73.061364,
      63.042628,
      172,
      13,
      ' 9- 4-1982',
      NULL,
      2,
      ' 1-23-1979',
      NULL,
      7.877972,
      18.556483,
      3.944478,
      24,
      16,
      1.107508,
      NULL,
      1,
      NULL,
      NULL,
      7.250457,
      19.329088,
      3.776382,
      NULL,
      NULL,
      8,
      6.853575,
      ' 6-17-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      118.337475,
      2.985648,
      '10- 1-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 3-1989',
      26,
      ' 4-14-1986',
      NULL,
      7.872010,
      ' 6- 7-1985',
      65,
      52,
      ' 6-13-1995',
      11,
      3.714109,
      '10-21-1982',
      NULL,
      NULL,
      NULL,
      1,
      1,
      32,
      ' 4-26-1982',
      NULL,
      16.004732,
      25,
      ' 6- 0-1979',
      3.911818,
      NULL,
      ' 2-12-1979',
      2,
      NULL,
      NULL,
      37.229912,
      '10-12-1974',
      56.810695,
      0.682046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


