set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8623103';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0103',
      '41301340',
      '14204101',
      '22113043',
      '14312121',
      '44312314',
      '20013320',
      '33302301',
      '02201100',
      '11311204',
      NULL,
      '01042210',
      '24141343',
      NULL,
      NULL,
      '11144140',
      '00032103',
      '10301024',
      NULL,
      '21411121',
      NULL,
      '41103010',
      '10300440',
      NULL,
      '14221000',
      '33002114',
      '00322410',
      '33211214',
      NULL,
      '30233421',
      '12020210',
      '21004331',
      '23031412',
      '41313112',
      '34124132',
      '00332042',
      '00114022',
      NULL,
      '01200131',
      '24143301',
      '41442201',
      '11240114',
      '22220413',
      '42243010',
      '32332433',
      '',
      '',
      NULL,
      NULL,
      '3420241',
      0,
      1,
      1,
      NULL,
      '344134',
      0.430364,
      '11- 8-1974',
      ' 0- 6-1986',
      40,
      NULL,
      21,
      NULL,
      0,
      10,
      NULL,
      NULL,
      14,
      8,
      28,
      8,
      14.135261,
      12,
      16.657187,
      15,
      32,
      25,
      11,
      4.238688,
      13,
      18,
      119.740308,
      7,
      NULL,
      NULL,
      86,
      67.321454,
      115,
      NULL,
      NULL,
      ' 8- 0-1992',
      39,
      NULL,
      10.388621,
      1,
      25,
      111,
      ' 7-21-1991',
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.206991,
      NULL,
      1.903233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-13-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 8-1990',
      5.072629,
      1.902731,
      71,
      NULL,
      33.353746,
      35.902100,
      49,
      NULL,
      80,
      NULL,
      91,
      NULL,
      ' 4- 3-2000',
      4,
      3,
      11.400647,
      71,
      3.130648,
      31.733029,
      8.800428,
      ' 2- 1-1985',
      24,
      14.697555,
      ' 7- 2-2000',
      0.889720,
      NULL,
      29.733971,
      17,
      NULL,
      0,
      NULL,
      4,
      NULL,
      7.415505,
      0.181792,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-20-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      50,
      NULL,
      36,
      NULL,
      NULL,
      19,
      '11-20-1974',
      NULL,
      NULL,
      17,
      10,
      ' 9-25-1988',
      49.651746,
      0,
      15.989675,
      ' 5-14-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      1.954600,
      70.869437,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      6,
      0.845990,
      NULL,
      1,
      0,
      51.643899,
      0,
      0,
      26,
      1,
      1.139697,
      NULL,
      0,
      0.095587,
      140,
      NULL,
      24,
      NULL,
      NULL,
      NULL,
      NULL,
      1.908506,
      1,
      0,
      NULL,
      1.407680,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.973345,
      NULL,
      1.428759,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      28,
      NULL,
      3,
      2,
      0.037135,
      NULL,
      1.488836,
      0.673507,
      1,
      1.124083,
      NULL,
      '11- 2-1987',
      NULL,
      ' 1-25-2002',
      NULL,
      ' 3-22-1989',
      ' 2- 0-1996',
      NULL,
      NULL);
commit;
end;
/


