set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9611246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3200',
      NULL,
      '14234213',
      '00033221',
      '31330244',
      '42033223',
      '44430100',
      NULL,
      NULL,
      NULL,
      '10334022',
      '20412330',
      '00411003',
      '12210203',
      '11143420',
      '34410032',
      NULL,
      '41000041',
      '11101014',
      '32401222',
      '31223141',
      '11310243',
      '24043310',
      '32232111',
      '40334033',
      '12304042',
      NULL,
      '43320320',
      '23004024',
      NULL,
      '22031102',
      '04031340',
      '04144441',
      '32113022',
      '01342221',
      '12013444',
      NULL,
      '03413424',
      '42033414',
      '00213414',
      '00200441',
      '34004312',
      '04230230',
      NULL,
      '00422242',
      '120',
      '12',
      7,
      3.217771,
      '3402143',
      NULL,
      0,
      NULL,
      NULL,
      '243230',
      2.832266,
      ' 8- 3-1974',
      ' 4- 4-1977',
      27.851645,
      NULL,
      42.465953,
      12,
      11.212784,
      NULL,
      88.286806,
      6.789649,
      NULL,
      22.577327,
      6.326493,
      11,
      36,
      NULL,
      NULL,
      NULL,
      NULL,
      19.637858,
      80.715940,
      17.266606,
      68.212464,
      0.908194,
      66,
      15.212746,
      1.981319,
      NULL,
      NULL,
      110.153148,
      24.419120,
      76.238734,
      47,
      NULL,
      12.220546,
      45.469153,
      35.350716,
      11,
      48,
      10,
      ' 5-11-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      94.622971,
      15.108904,
      NULL,
      NULL,
      4.399552,
      NULL,
      '11-28-1992',
      0,
      1,
      37,
      1,
      NULL,
      NULL,
      NULL,
      5.482305,
      55.567756,
      NULL,
      NULL,
      NULL,
      ' 0- 3-1982',
      NULL,
      NULL,
      NULL,
      50.149955,
      86.268774,
      76.519571,
      38.316738,
      72,
      43,
      87.887829,
      50,
      25.892194,
      NULL,
      3,
      NULL,
      6.623785,
      NULL,
      10,
      77.865761,
      NULL,
      '10-27-1977',
      12,
      0,
      ' 2-26-1985',
      7,
      2.845040,
      14,
      NULL,
      1.160540,
      2,
      1,
      17.774341,
      1.979415,
      61.244694,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.260200,
      ' 5- 8-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      75,
      4.908280,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      35.477336,
      NULL,
      17.585225,
      17,
      ' 3-20-1983',
      2,
      NULL,
      '11- 3-1986',
      1,
      1.285038,
      ' 8-28-1979',
      NULL,
      NULL,
      NULL,
      3,
      1,
      4,
      NULL,
      37,
      15.539742,
      NULL,
      ' 9-29-1984',
      1,
      64,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


