set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9115135';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1312',
      '22331223',
      '21213011',
      '30303144',
      '23323021',
      '23420034',
      '42222213',
      '21242014',
      '33414141',
      NULL,
      '24043021',
      NULL,
      '33001143',
      '03213400',
      '02021401',
      NULL,
      '42032303',
      '43421203',
      '32421014',
      '31133424',
      '22033040',
      '42021030',
      '13313244',
      '13032213',
      NULL,
      '33103434',
      '12130211',
      '20001321',
      '41111011',
      '02241330',
      '43132224',
      '22431322',
      '44401122',
      NULL,
      '14301302',
      '12034214',
      '11333422',
      '21233113',
      NULL,
      '24432031',
      '23000413',
      '44242333',
      '04110044',
      '32244003',
      NULL,
      '011',
      '12',
      NULL,
      NULL,
      '3231134',
      1.789585,
      1,
      3,
      NULL,
      '222133',
      2,
      NULL,
      ' 2-17-1979',
      NULL,
      NULL,
      13,
      19,
      30.833801,
      31,
      NULL,
      32,
      21.515058,
      6,
      26.806882,
      19.612352,
      2,
      8.893282,
      NULL,
      3,
      0,
      15.653328,
      46,
      25,
      52,
      NULL,
      51.110266,
      NULL,
      1,
      77.239708,
      110.867721,
      139.789151,
      14.136048,
      166.260065,
      190.585733,
      ' 1-18-1994',
      50,
      18.090887,
      NULL,
      18,
      71.202480,
      124.517060,
      NULL,
      0,
      0.533080,
      0.162613,
      NULL,
      0,
      0.234861,
      0,
      NULL,
      0.651959,
      0.693552,
      0,
      0.033510,
      1,
      1,
      NULL,
      0,
      1,
      0.532905,
      1.147549,
      0.056057,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-18-1974',
      NULL,
      3.632501,
      1,
      7,
      0,
      9.610911,
      ' 0-24-1980',
      NULL,
      NULL,
      NULL,
      0.994269,
      0,
      20,
      1,
      1,
      104.803853,
      1,
      NULL,
      NULL,
      '10-15-1980',
      22,
      79,
      NULL,
      24,
      NULL,
      51.306459,
      NULL,
      68.265023,
      97,
      93.718696,
      90,
      16.162999,
      ' 8-15-1999',
      17.486365,
      NULL,
      9.018925,
      93,
      69,
      108,
      NULL,
      ' 5- 5-1989',
      NULL,
      26,
      ' 4-27-2000',
      10.033797,
      13,
      17.627476,
      21,
      19.573732,
      11,
      0.285048,
      1.652044,
      0.068983,
      144,
      0,
      1.815085,
      1.767983,
      1.522308,
      1,
      1,
      NULL,
      NULL,
      ' 4-14-1977',
      6,
      2.061657,
      3.109319,
      NULL,
      195,
      NULL,
      '10-24-1989',
      NULL,
      3.699812,
      ' 2-19-1975',
      NULL,
      ' 7- 9-1980',
      13.807123,
      ' 3-14-1989',
      14,
      5.182452,
      ' 2- 2-1993',
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      ' 5-26-2002',
      3.998945,
      11.447539,
      '11-27-1982',
      NULL,
      0,
      7,
      ' 4-19-2001',
      12,
      NULL,
      NULL,
      ' 3- 1-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11);
commit;
end;
/


