set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5513125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '32203443',
      '21124004',
      NULL,
      '23232300',
      '44403244',
      '04220224',
      '02423400',
      '20432444',
      '40343312',
      '30303011',
      '22113004',
      NULL,
      NULL,
      '43341434',
      '42134112',
      '10213431',
      NULL,
      '30304241',
      '04211334',
      '31232140',
      '31042131',
      '01424234',
      '30341113',
      '42321013',
      '34400342',
      '04240311',
      '44240140',
      NULL,
      NULL,
      NULL,
      '22404132',
      '32122210',
      '43431344',
      NULL,
      '44144143',
      '13013203',
      '02040032',
      '34001022',
      '34424341',
      '31103022',
      '10223332',
      '33114334',
      '03402311',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '4012340',
      0.661011,
      1,
      1,
      NULL,
      '224223',
      3,
      ' 9-16-1990',
      NULL,
      32,
      NULL,
      15,
      NULL,
      15.119677,
      NULL,
      NULL,
      6.406379,
      NULL,
      8,
      19.330921,
      NULL,
      4.619572,
      10,
      4,
      NULL,
      1,
      8,
      4.257593,
      0.903086,
      23.477074,
      0.920232,
      10.622136,
      9.485581,
      NULL,
      26,
      NULL,
      NULL,
      122.428072,
      29.480837,
      144.251811,
      ' 0-12-1990',
      23.192747,
      8,
      17.254080,
      NULL,
      99,
      NULL,
      ' 6-12-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-16-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      15,
      7.846605,
      59.295953,
      NULL,
      NULL,
      NULL,
      ' 7-25-1974',
      NULL,
      0.346420,
      NULL,
      10,
      3,
      0,
      6.864104,
      2,
      6.179406,
      NULL,
      1.241121,
      NULL,
      62,
      9.817703,
      2.409192,
      12.329298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-24-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      3.276577,
      2,
      '10-20-1978',
      0,
      53.089459,
      NULL,
      NULL,
      17,
      NULL,
      5,
      ' 4-12-1998',
      1,
      0,
      17,
      ' 2- 5-1984',
      NULL,
      NULL,
      NULL,
      40.998561,
      NULL,
      NULL,
      NULL,
      NULL,
      69,
      66.937389,
      6.976989,
      NULL,
      37.874562,
      0,
      72,
      NULL,
      NULL,
      110.209072,
      3,
      1.445499,
      NULL,
      1,
      7.313457,
      181,
      1,
      15.234513,
      262,
      NULL,
      2,
      NULL,
      NULL,
      8.348901,
      0.676769,
      1,
      1,
      1.271891,
      1.993214,
      1,
      6,
      NULL,
      60.359133,
      16.002004,
      48.929477,
      54,
      NULL,
      1,
      25,
      0,
      0.091055,
      0,
      21.030621,
      0.300291,
      25.556560,
      NULL,
      62.456216,
      0,
      8,
      4.915138,
      2.042759,
      2,
      0.677733,
      65,
      NULL,
      15,
      NULL,
      3.652425,
      NULL,
      1.434587,
      0.916017,
      3.471917,
      0.656260,
      1.389114,
      0.940161,
      33,
      NULL,
      ' 8- 6-1987',
      NULL,
      NULL,
      ' 6- 5-2003',
      ' 7-23-1984',
      ' 3-21-2003',
      NULL);
commit;
end;
/


