set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9756071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      '1',
      '3',
      NULL,
      '2',
      '0',
      '2',
      '3',
      '3',
      NULL,
      '1',
      '0',
      '4',
      '3',
      '3',
      '3',
      NULL,
      '2',
      NULL,
      '4',
      '3',
      '0',
      NULL,
      NULL,
      '4',
      '',
      '2',
      '3',
      '0',
      NULL,
      '0',
      NULL,
      '',
      NULL,
      '3',
      NULL,
      NULL,
      '2',
      '4',
      '3',
      '1',
      '0',
      '3',
      '3',
      '240',
      '24034212',
      NULL,
      NULL,
      '3443232',
      1,
      1.946566,
      3,
      NULL,
      '104222',
      0,
      ' 3- 4-1995',
      NULL,
      73,
      253.931089,
      31.433724,
      16,
      6.746072,
      2,
      52.725191,
      4,
      24.459305,
      9,
      1,
      5.043128,
      15.930604,
      2.470001,
      13.603082,
      1,
      22.337900,
      16,
      69.845676,
      1.786027,
      9.896703,
      5,
      48,
      4,
      0,
      11.942077,
      114.435911,
      1.764345,
      19.321192,
      28,
      NULL,
      ' 8-12-1981',
      25,
      NULL,
      19,
      14.378676,
      118,
      68,
      ' 9-27-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      NULL,
      10.020659,
      NULL,
      10.513129,
      NULL,
      ' 0-16-1998',
      0.457042,
      NULL,
      172,
      0.720825,
      NULL,
      53,
      0.087276,
      1,
      27.116445,
      NULL,
      NULL,
      NULL,
      NULL,
      9.830880,
      74.487216,
      24,
      NULL,
      67,
      70,
      0,
      75,
      NULL,
      61,
      47.109514,
      2,
      ' 2-29-1985',
      1.818705,
      5,
      12,
      48.220813,
      27,
      73,
      7.817116,
      NULL,
      29.384706,
      3,
      NULL,
      15.611899,
      16,
      13.150830,
      10,
      25.098980,
      NULL,
      1,
      9,
      0,
      NULL,
      7,
      1.991279,
      4.544846,
      NULL,
      NULL,
      2.836592,
      3,
      2.805972,
      ' 4-12-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      293.190817,
      2.674704,
      ' 6- 2-1995',
      NULL,
      NULL,
      NULL,
      48.412739,
      ' 1- 3-1975',
      NULL,
      ' 3- 1-1999',
      2.268137,
      5.166176,
      ' 9-29-1995',
      NULL,
      92,
      '10- 7-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      14.634097,
      ' 6-12-1992',
      29,
      35.327099,
      21.668415,
      NULL,
      NULL,
      26,
      ' 8- 5-1977',
      14.684122,
      14.562371,
      21.045079,
      28.022401,
      NULL,
      39,
      0.707683,
      NULL,
      '11- 3-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


