set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531718';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02301042',
      '23034012',
      '31324324',
      '30031313',
      '20424422',
      '00444233',
      '22401022',
      '24140402',
      '20014134',
      '30324021',
      '32002401',
      '40014122',
      NULL,
      '23301340',
      NULL,
      '12310214',
      '43320144',
      NULL,
      '02431320',
      '34243303',
      '03214212',
      '34401214',
      NULL,
      '13131244',
      '43013411',
      NULL,
      '20110011',
      '22441024',
      '42020110',
      '00221113',
      '40122131',
      '21414122',
      '40432203',
      '24221444',
      '02433244',
      NULL,
      '02312022',
      '14431112',
      '40043034',
      '03442414',
      '21314243',
      '14032410',
      '01224420',
      NULL,
      '144',
      '34',
      NULL,
      NULL,
      NULL,
      3.215841,
      NULL,
      0,
      NULL,
      '312231',
      2,
      NULL,
      ' 8-19-1982',
      65.568119,
      NULL,
      NULL,
      12.609350,
      21,
      NULL,
      15,
      9,
      4,
      2,
      18,
      NULL,
      25.929126,
      NULL,
      24.145499,
      NULL,
      NULL,
      NULL,
      2.783538,
      9.069489,
      35.217865,
      NULL,
      24.287857,
      8,
      0,
      NULL,
      78.967314,
      70.314719,
      27,
      NULL,
      50.945594,
      ' 4-28-1975',
      9,
      1.500044,
      10,
      NULL,
      62,
      NULL,
      NULL,
      9,
      6,
      2,
      5,
      0.738843,
      4,
      3,
      NULL,
      1,
      2,
      4,
      1.911853,
      0.277844,
      3,
      1,
      1.101862,
      1.382090,
      1.397193,
      NULL,
      1.416241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42.550650,
      19.704096,
      12.523187,
      19,
      17.151785,
      0,
      NULL,
      1.543355,
      5,
      100,
      1,
      0.809674,
      23.742381,
      2.309217,
      NULL,
      8.193840,
      NULL,
      NULL,
      NULL,
      ' 9- 7-1991',
      37,
      NULL,
      81.018410,
      66,
      16,
      59,
      NULL,
      91,
      43,
      NULL,
      13,
      NULL,
      ' 1-29-1988',
      NULL,
      9.034065,
      5.643840,
      7,
      39.285296,
      11.420400,
      0.717858,
      NULL,
      11.187932,
      NULL,
      ' 5-10-1984',
      1.236591,
      6.877233,
      11.710059,
      6.407869,
      NULL,
      3.203635,
      NULL,
      6,
      NULL,
      107.968949,
      NULL,
      1,
      7.411058,
      19,
      1.258553,
      1.706216,
      3,
      0,
      ' 5-29-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      105,
      18.647533,
      ' 6- 0-1998',
      NULL,
      NULL,
      NULL,
      39.992216,
      ' 0- 3-1974',
      7.095632,
      ' 1- 4-1998',
      1,
      7.406541,
      ' 0-14-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 4-19-1993',
      45,
      4,
      8.430028,
      '10-13-2001',
      5.062193,
      57.092785,
      NULL,
      1,
      NULL,
      1,
      66,
      ' 3- 8-1980',
      55,
      NULL,
      85.057856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


