set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531718';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      '0',
      '3',
      '3',
      '2',
      '2',
      '3',
      '4',
      '4',
      '3',
      '4',
      '2',
      '0',
      '0',
      '1',
      '3',
      NULL,
      NULL,
      '3',
      '2',
      '4',
      '1',
      '0',
      '',
      '1',
      '',
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      '',
      '',
      '0',
      '4',
      '4',
      '1',
      '2',
      '3',
      '3',
      '4',
      NULL,
      NULL,
      '3',
      '013',
      '12220322',
      43.227223,
      16,
      '0221001',
      2,
      114.665980,
      2,
      NULL,
      '102304',
      NULL,
      '10-25-1979',
      '11- 0-1989',
      60.008288,
      93.158640,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      8,
      6,
      10,
      8.694973,
      6.681141,
      13.515708,
      7.014658,
      13.256630,
      27.137037,
      13,
      21,
      6.717521,
      NULL,
      10.175170,
      NULL,
      8,
      20.039516,
      6,
      141,
      53,
      60.113745,
      ' 8-16-1989',
      NULL,
      14.795246,
      8,
      12.514408,
      76.403525,
      125.018122,
      ' 7- 7-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54,
      35,
      14.826051,
      NULL,
      NULL,
      1.859619,
      ' 2-17-1998',
      1,
      1,
      81.279018,
      NULL,
      1,
      89.824779,
      1.397495,
      2,
      8.832282,
      NULL,
      NULL,
      NULL,
      ' 6-17-1991',
      1.422969,
      41,
      15.313418,
      NULL,
      36,
      93,
      71.719874,
      41.236249,
      72.574133,
      80,
      42.786929,
      24.809483,
      ' 7- 0-2001',
      9,
      18,
      NULL,
      NULL,
      48,
      NULL,
      6.770029,
      ' 7- 6-1986',
      5,
      1,
      ' 0- 3-1989',
      2,
      0,
      3.219472,
      2,
      23.891209,
      6,
      0,
      8,
      0.519308,
      7,
      1.049421,
      NULL,
      10.893916,
      1,
      NULL,
      NULL,
      1,
      1.922647,
      ' 5-25-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      93,
      ' 6- 9-1995',
      NULL,
      NULL,
      NULL,
      49,
      ' 6- 1-1978',
      16,
      '11- 7-1992',
      2.879619,
      0.371640,
      ' 3-26-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      '11-28-1975',
      12,
      NULL,
      10.609079,
      ' 9-18-2000',
      NULL,
      NULL,
      ' 4-15-1999',
      7,
      216,
      18,
      NULL,
      ' 4-16-1992',
      20,
      1.618498,
      129.598777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


