set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531718';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      '2',
      NULL,
      '2',
      NULL,
      '1',
      '0',
      NULL,
      '4',
      '4',
      NULL,
      '3',
      '4',
      '3',
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '',
      '4',
      '1',
      '0',
      '3',
      '4',
      '',
      '',
      '1',
      '0',
      '1',
      '4',
      '1',
      '2',
      '2',
      '0',
      '4',
      NULL,
      NULL,
      '442',
      '00024140',
      NULL,
      91,
      '0243142',
      0.041435,
      7,
      NULL,
      1,
      '420422',
      1,
      '10-28-1987',
      ' 7-11-1985',
      146,
      105.446480,
      11,
      13,
      3,
      0.140075,
      NULL,
      0,
      2,
      1.621926,
      4,
      2.265362,
      NULL,
      1.034479,
      20.535742,
      13.555615,
      1,
      NULL,
      28,
      7,
      8.618012,
      13,
      51,
      5,
      NULL,
      36,
      127.388245,
      14,
      71.093618,
      62,
      26,
      NULL,
      19.054081,
      1,
      26,
      11,
      NULL,
      132.607116,
      '11- 9-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      18,
      14,
      6,
      1,
      ' 1-29-1996',
      1.479497,
      0,
      81.697732,
      1.695493,
      9.712481,
      87,
      1.182538,
      6.332710,
      50.881597,
      NULL,
      NULL,
      NULL,
      '10-25-1981',
      94.040324,
      103.036747,
      81,
      80.403226,
      36.332438,
      59.302205,
      56.847192,
      87,
      NULL,
      24.117621,
      NULL,
      65.077630,
      NULL,
      8.644226,
      13.442033,
      4,
      27.010916,
      1,
      12,
      7,
      ' 5-15-1978',
      14,
      5,
      ' 0- 8-1997',
      9.356375,
      3.849418,
      11,
      19,
      14,
      0,
      0.412530,
      11.914036,
      2,
      52.547154,
      NULL,
      35,
      14,
      5.084319,
      NULL,
      4,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-15-1977',
      NULL,
      ' 7-21-1984',
      3,
      4.522619,
      ' 9-19-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      ' 7-29-2000',
      13.100898,
      NULL,
      19,
      ' 6- 8-1983',
      NULL,
      85.562538,
      '11-25-1988',
      8.112795,
      16.418742,
      1.575961,
      NULL,
      NULL,
      34,
      1,
      136,
      '10- 1-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


