set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131717';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3344',
      NULL,
      '20312032',
      '43012224',
      '41334204',
      '33312004',
      '01013134',
      '13433101',
      '03204001',
      '04422244',
      '41231400',
      '02030121',
      '10012210',
      '23103322',
      '42131023',
      NULL,
      '21430000',
      '40142021',
      '33040230',
      '40012134',
      '00123323',
      '04223441',
      '43101311',
      '21131440',
      NULL,
      '14240010',
      '40011043',
      '22201424',
      NULL,
      '11310123',
      NULL,
      '10102041',
      '14230422',
      '04120124',
      '33030444',
      '04214010',
      '23321044',
      '33341330',
      '14434123',
      '33214133',
      '10000241',
      '41404424',
      '02014232',
      '32323332',
      '33124223',
      NULL,
      '40',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '240444',
      0,
      ' 6-20-1999',
      ' 0-16-1993',
      35,
      NULL,
      5.156755,
      2.234539,
      7,
      8,
      0,
      5.643295,
      7,
      5,
      9.742811,
      NULL,
      3,
      1,
      7.879601,
      2,
      2,
      1,
      12.259699,
      NULL,
      NULL,
      2,
      13.688435,
      NULL,
      1,
      38.031691,
      81,
      19.548726,
      NULL,
      85,
      NULL,
      ' 6-12-2001',
      16.940046,
      11.668104,
      12,
      16.976121,
      185.443400,
      NULL,
      ' 0-27-1990',
      2,
      7,
      NULL,
      2,
      NULL,
      1.955047,
      6.026630,
      2,
      0.248862,
      0.135325,
      9,
      1.481520,
      0,
      1,
      0.689198,
      1,
      0.372481,
      1.690924,
      0.184039,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 5-1985',
      55.967323,
      30.092892,
      36,
      10,
      16,
      3.210560,
      ' 1-11-1991',
      2.544916,
      NULL,
      69,
      7.960725,
      0,
      9.746383,
      8,
      NULL,
      7,
      1,
      2,
      11,
      ' 5- 8-2002',
      20.255298,
      108,
      6,
      111,
      114.420601,
      97,
      63,
      38,
      7,
      NULL,
      NULL,
      NULL,
      ' 6-19-1994',
      8,
      1,
      5.773922,
      24,
      19.992050,
      1.098613,
      1.112476,
      NULL,
      0.985892,
      0,
      ' 7- 4-1992',
      1.554059,
      NULL,
      7,
      2.897573,
      3.559374,
      1.772910,
      1,
      NULL,
      0,
      24,
      1.959880,
      1,
      0,
      1.073041,
      23.880979,
      3,
      6.606695,
      3,
      NULL,
      NULL,
      0.410597,
      0.532729,
      ' 7-22-1984',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.532667,
      NULL,
      15.996776,
      NULL,
      NULL,
      7.848782,
      ' 8-19-1994',
      NULL,
      33.499919,
      ' 1-21-1976',
      8,
      4.216414,
      ' 1-21-1995',
      NULL,
      3.748487,
      NULL,
      0,
      NULL,
      19.538206,
      '10-14-1981',
      34,
      11.576698,
      7.214722,
      ' 6- 7-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.184827);
commit;
end;
/


