set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9769062';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '4',
      '3',
      '2',
      NULL,
      '4',
      '1',
      '2',
      '0',
      '4',
      '4',
      '2',
      '4',
      NULL,
      '1',
      '3',
      '0',
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '0',
      '',
      '0',
      '',
      '3',
      '4',
      '1',
      '2',
      '3',
      '',
      '',
      '3',
      '0',
      '0',
      '0',
      '3',
      NULL,
      '3',
      '0',
      '1',
      '3',
      '1',
      '043',
      '42314301',
      17.150916,
      32.227481,
      '1232120',
      2,
      NULL,
      0,
      NULL,
      '001033',
      0.863146,
      ' 5-10-1980',
      NULL,
      NULL,
      31.011132,
      17,
      20,
      5.440175,
      NULL,
      62.325446,
      26.165518,
      8.870259,
      25.410858,
      42,
      NULL,
      27.868582,
      0.033029,
      4,
      22.274324,
      28,
      13,
      78,
      NULL,
      NULL,
      NULL,
      47,
      6.068924,
      0.331316,
      NULL,
      126,
      65,
      100,
      218,
      91.020169,
      '10-16-1976',
      29.423914,
      45,
      4.573553,
      NULL,
      29.823346,
      234.491398,
      '11-15-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      2.543030,
      NULL,
      2,
      2,
      9,
      '11- 2-1980',
      NULL,
      0,
      84,
      2,
      3.402266,
      77.324326,
      0,
      NULL,
      34.696066,
      NULL,
      NULL,
      NULL,
      ' 3-16-2001',
      3.527449,
      97.317673,
      NULL,
      104.161762,
      NULL,
      48.454634,
      63.456227,
      70.112115,
      28.834799,
      62,
      NULL,
      53,
      ' 1- 8-1995',
      35,
      NULL,
      25,
      NULL,
      48.626796,
      150.991669,
      9,
      ' 6-19-1994',
      5.480026,
      27.894702,
      ' 6-22-1977',
      NULL,
      29.687783,
      NULL,
      6,
      21.381092,
      13.808142,
      1,
      19,
      0.740915,
      28,
      1.150908,
      1.380017,
      25,
      1.722686,
      1,
      0.692581,
      0.674663,
      0.880046,
      ' 9-21-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      203.387367,
      1.575534,
      ' 1-27-2003',
      NULL,
      NULL,
      NULL,
      40.877050,
      NULL,
      26,
      ' 7-10-2000',
      NULL,
      7,
      ' 0- 6-1999',
      NULL,
      NULL,
      ' 6- 8-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      ' 1-15-1987',
      70.227109,
      28.501544,
      21.358455,
      NULL,
      0,
      103.875595,
      ' 9-29-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


