set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9795740';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      '2',
      '1',
      '2',
      '0',
      '4',
      NULL,
      NULL,
      '1',
      '2',
      '4',
      NULL,
      '1',
      '0',
      '3',
      '0',
      NULL,
      NULL,
      '2',
      '2',
      '4',
      NULL,
      '3',
      '',
      NULL,
      '',
      '3',
      NULL,
      '4',
      '1',
      NULL,
      '',
      NULL,
      NULL,
      '4',
      '3',
      '4',
      '4',
      '2',
      '3',
      '1',
      '1',
      '1',
      '1',
      '414',
      '14230442',
      60,
      56,
      '4400123',
      0,
      NULL,
      0,
      NULL,
      '340123',
      0,
      ' 6- 7-1984',
      ' 8-14-1995',
      77.543178,
      NULL,
      37,
      17.109736,
      NULL,
      26,
      4,
      3,
      14,
      15,
      2.685349,
      1,
      5,
      NULL,
      7.184571,
      12,
      16.680174,
      11,
      84,
      34.311823,
      NULL,
      18.074958,
      0.298514,
      NULL,
      2.951157,
      120.280685,
      107.517924,
      80,
      NULL,
      190,
      100.930813,
      ' 9-26-1996',
      29.688633,
      65,
      9,
      NULL,
      NULL,
      170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      65,
      NULL,
      6,
      0.130193,
      6,
      5,
      NULL,
      1.311510,
      0.887898,
      146,
      0,
      3,
      155,
      1.397438,
      1,
      13.679849,
      NULL,
      NULL,
      NULL,
      NULL,
      103,
      37,
      54.152934,
      69,
      67.432016,
      53.819384,
      NULL,
      19,
      24,
      43.981833,
      31.673951,
      57.810891,
      ' 5-10-1984',
      NULL,
      24,
      2,
      4,
      NULL,
      123.538479,
      1.164113,
      ' 0-22-1993',
      12,
      15,
      ' 4-12-1986',
      10,
      NULL,
      NULL,
      23.715154,
      7,
      NULL,
      NULL,
      22.716414,
      NULL,
      28.623830,
      NULL,
      0,
      2.742924,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      148,
      1.509312,
      ' 7-18-1999',
      NULL,
      NULL,
      NULL,
      19,
      ' 5-18-1979',
      53,
      ' 2-10-2002',
      NULL,
      NULL,
      '11-25-1980',
      108,
      128,
      ' 4-27-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      26,
      45.209982,
      4.753246,
      NULL,
      NULL,
      NULL,
      ' 3-10-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


