set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4705916';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4441',
      NULL,
      '22343102',
      '40223411',
      '20023403',
      '13212101',
      NULL,
      '12342203',
      '41443302',
      '23234024',
      '32320441',
      '11142311',
      '33122440',
      '22042403',
      '23123342',
      NULL,
      NULL,
      '33320421',
      NULL,
      NULL,
      '33303034',
      NULL,
      '02021034',
      NULL,
      NULL,
      '23140243',
      '32333042',
      '44041112',
      '33200120',
      '34014312',
      NULL,
      '32220124',
      '20114330',
      '00111322',
      '11033232',
      '30413321',
      '32201331',
      '02220012',
      '03030123',
      '24043443',
      '33423123',
      '01444430',
      '44321344',
      '10024434',
      '44430441',
      '433',
      '40',
      NULL,
      NULL,
      '4320042',
      NULL,
      1,
      2,
      NULL,
      '422032',
      3.305473,
      ' 9-10-1981',
      ' 1-11-1974',
      7.521508,
      NULL,
      2,
      21,
      NULL,
      NULL,
      106.836667,
      9,
      3.020192,
      22.659567,
      NULL,
      NULL,
      39.813797,
      14.493057,
      NULL,
      11,
      2.462228,
      18,
      NULL,
      15,
      NULL,
      8,
      98.796093,
      10.103311,
      1.673300,
      NULL,
      168,
      34,
      29.472687,
      215.559945,
      82.040685,
      ' 0-13-1982',
      9.424023,
      13.303213,
      23,
      0.151207,
      42.593161,
      51,
      NULL,
      1,
      3.648572,
      4,
      NULL,
      0,
      3,
      0.778369,
      NULL,
      1.093435,
      0,
      4.085102,
      1.826074,
      1,
      NULL,
      0.795755,
      0.129268,
      5,
      1.769537,
      0.122361,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-23-1988',
      15,
      32.700086,
      10.230458,
      9,
      NULL,
      0.433404,
      ' 1- 3-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      80.163840,
      NULL,
      41.236103,
      NULL,
      NULL,
      95.477376,
      56,
      95,
      1,
      NULL,
      73.560049,
      76,
      '11- 2-1989',
      23.067301,
      2.458424,
      14,
      43.704141,
      16.982209,
      88.364128,
      0,
      NULL,
      10.655076,
      1,
      ' 9-14-1985',
      5.605739,
      NULL,
      2.561446,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      1.355659,
      7.516942,
      NULL,
      21,
      13,
      NULL,
      3,
      3.778950,
      1.384518,
      1,
      NULL,
      8.155431,
      NULL,
      0,
      ' 0- 7-2003',
      159.829647,
      1.328741,
      ' 8-18-1974',
      6,
      24.502073,
      ' 8-12-1982',
      41,
      ' 6- 7-1994',
      NULL,
      ' 0- 4-1984',
      7.596570,
      15.228928,
      ' 8-28-1978',
      63.651438,
      10.083312,
      ' 6-26-1999',
      2,
      2.644441,
      NULL,
      0,
      5.398130,
      ' 8- 9-1989',
      3,
      0,
      8,
      ' 6- 3-1990',
      14,
      11.302210,
      17,
      ' 9-29-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


