set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9324257';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3343',
      '20000231',
      '14103400',
      '40040022',
      NULL,
      '24440141',
      '30131324',
      NULL,
      '44224234',
      '14201340',
      NULL,
      '40420410',
      '03013340',
      '01340413',
      '12424103',
      NULL,
      '40434023',
      '21322211',
      NULL,
      '44214003',
      '24232103',
      '41333400',
      NULL,
      '03130424',
      '44422021',
      NULL,
      NULL,
      '23230413',
      '32330123',
      '44443141',
      NULL,
      NULL,
      NULL,
      '24023144',
      '32410312',
      '43443443',
      NULL,
      '12420420',
      '32220314',
      '00443314',
      '40021401',
      '21134331',
      NULL,
      '44001021',
      '20334224',
      '444',
      '42',
      23,
      0.305576,
      '0332430',
      0,
      1,
      0,
      NULL,
      '310401',
      NULL,
      ' 4-15-1989',
      ' 7- 5-1978',
      18.719150,
      14.032094,
      35.565441,
      19,
      14,
      6.137840,
      10,
      5,
      16,
      NULL,
      NULL,
      7.901873,
      34,
      18.579061,
      20,
      0.998060,
      NULL,
      5,
      49,
      14,
      31,
      3,
      48.703519,
      0,
      0,
      43,
      227,
      38,
      17.116258,
      58,
      153,
      NULL,
      13,
      45.277945,
      17,
      22.357595,
      NULL,
      47.674359,
      '10-24-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33,
      7,
      6.978501,
      9,
      2,
      2,
      NULL,
      1.575598,
      0,
      137.945284,
      0,
      0.737717,
      NULL,
      1.793933,
      NULL,
      36.337321,
      NULL,
      NULL,
      NULL,
      ' 7-19-2001',
      41.403467,
      61,
      76,
      20,
      NULL,
      NULL,
      24,
      41.925451,
      76,
      38,
      58,
      14.723770,
      ' 0-29-1982',
      6,
      29,
      19,
      NULL,
      NULL,
      NULL,
      0.245391,
      ' 5-23-1985',
      21.074143,
      NULL,
      NULL,
      12,
      13.387314,
      8,
      21.409684,
      0.988277,
      NULL,
      1,
      NULL,
      0.311950,
      135.342516,
      1,
      0.624822,
      0,
      31,
      NULL,
      NULL,
      1,
      1,
      ' 6-23-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      57,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      51.333843,
      '10- 8-1998',
      NULL,
      ' 4- 3-1979',
      NULL,
      13.984395,
      ' 0-28-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      17,
      ' 1- 9-1995',
      14,
      45.582144,
      12.880967,
      ' 6-19-2001',
      1,
      NULL,
      '10-14-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


