set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9665591';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2231',
      NULL,
      '12012124',
      '03131121',
      '00440312',
      '03132023',
      '44410304',
      '34234234',
      '14221334',
      '33121443',
      '32033332',
      '01022003',
      '02112213',
      '10303242',
      '24121424',
      '00420123',
      '42340034',
      NULL,
      '22200022',
      '04340134',
      '32033043',
      '31400103',
      '12242202',
      NULL,
      '40132200',
      '22144414',
      '12430401',
      '41124044',
      '21311440',
      '13440004',
      '23422303',
      '14004222',
      '10404021',
      '12222033',
      NULL,
      '10414032',
      NULL,
      NULL,
      '31002021',
      '30441320',
      '33424331',
      NULL,
      '30441421',
      '41013400',
      '34310404',
      '140',
      '33',
      32.587066,
      11,
      '4412232',
      2.525139,
      NULL,
      3,
      NULL,
      '322002',
      3.691345,
      ' 0- 4-2000',
      ' 8-16-1992',
      95,
      91.499234,
      11,
      NULL,
      12.167607,
      NULL,
      NULL,
      10,
      5.419866,
      6.136983,
      15,
      3,
      11,
      9,
      NULL,
      3,
      5.777511,
      NULL,
      0.038631,
      3,
      4.477198,
      8.165982,
      55,
      4,
      1,
      21,
      73,
      22.352256,
      107,
      30.121814,
      115.051138,
      ' 5-14-1997',
      36,
      6,
      14.756668,
      9,
      7,
      113,
      ' 0-12-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      14.256231,
      56,
      17,
      0.686683,
      ' 0-16-1985',
      1.776787,
      NULL,
      129,
      1,
      1.819421,
      37,
      3.340511,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      ' 5- 4-1976',
      14,
      31.172217,
      16,
      85,
      NULL,
      61,
      65,
      24.270765,
      0,
      56,
      10,
      88,
      ' 6-14-1993',
      23,
      17,
      12,
      NULL,
      NULL,
      93,
      NULL,
      NULL,
      6,
      2,
      ' 0- 7-1985',
      7.892311,
      0.272199,
      6,
      9,
      0.537694,
      5,
      3,
      1.202769,
      1.312594,
      NULL,
      2.045891,
      1.655142,
      NULL,
      NULL,
      4.748812,
      17.724027,
      1.410134,
      4.303638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      ' 9-21-1998',
      26,
      ' 1-29-1978',
      0,
      NULL,
      '10-20-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      27.033094,
      NULL,
      19,
      27,
      31,
      NULL,
      1,
      57.783017,
      '11- 4-1980',
      4.502029,
      72,
      13,
      30.344969,
      NULL,
      NULL,
      0,
      NULL,
      ' 9- 0-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


