set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8907347';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41141312',
      NULL,
      '00144042',
      '43000340',
      '02330211',
      '42311312',
      '22241032',
      NULL,
      '44122201',
      NULL,
      '04134423',
      '10212311',
      '02131303',
      '13303412',
      '33231442',
      '30201211',
      '10411204',
      '01321031',
      '30204224',
      NULL,
      '40210310',
      NULL,
      '03342301',
      '41430413',
      '34310244',
      '31404212',
      '20134243',
      '41424230',
      '24420342',
      '42313100',
      '23003332',
      '33233341',
      '31304000',
      '04130032',
      '22214301',
      '24122343',
      NULL,
      '43303041',
      NULL,
      '40244012',
      NULL,
      '20232423',
      NULL,
      NULL,
      NULL,
      '40',
      NULL,
      NULL,
      '2040302',
      1,
      1.863521,
      1,
      NULL,
      '224120',
      NULL,
      ' 6- 8-1982',
      ' 3- 2-1977',
      10,
      NULL,
      1.064863,
      10.431518,
      34,
      2.853951,
      NULL,
      5,
      19,
      10,
      NULL,
      21.335109,
      41,
      6.279428,
      5,
      1,
      9.618581,
      17.396408,
      69.491338,
      12.429542,
      17.048881,
      2,
      49,
      26,
      0.827856,
      NULL,
      21,
      19,
      NULL,
      43,
      205.733950,
      ' 6- 9-1979',
      43,
      49.829623,
      NULL,
      NULL,
      69,
      183.239382,
      NULL,
      0.602147,
      1.084705,
      NULL,
      NULL,
      1.524591,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      0.568434,
      0.001662,
      2.086837,
      1.930634,
      1,
      0.176328,
      NULL,
      NULL,
      1.492991,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-12-1992',
      4,
      15.547590,
      9,
      NULL,
      2,
      7.452491,
      ' 9-13-2001',
      0,
      1,
      NULL,
      1.180181,
      2,
      60,
      0.076362,
      NULL,
      NULL,
      NULL,
      0.746671,
      201,
      ' 5- 7-1999',
      71.816174,
      56.193593,
      65.844213,
      100,
      49.547286,
      12.072406,
      28.040250,
      94,
      76,
      0.457136,
      86.205684,
      63.286942,
      NULL,
      0.927566,
      15.638244,
      27,
      27.953216,
      23.505785,
      26,
      NULL,
      ' 3- 1-1995',
      31,
      NULL,
      ' 3- 2-1994',
      10,
      27,
      NULL,
      NULL,
      18.872529,
      6.210371,
      NULL,
      18.133702,
      1.091198,
      158.669505,
      0.587091,
      0.165868,
      23.071412,
      0,
      0,
      1,
      NULL,
      NULL,
      '10-17-1986',
      1.251439,
      NULL,
      4,
      ' 4-21-1976',
      119.289050,
      23.538608,
      '10-26-1993',
      10,
      23,
      ' 8- 1-2003',
      NULL,
      ' 5-28-2002',
      21,
      ' 3-25-1974',
      NULL,
      9,
      NULL,
      NULL,
      98.375249,
      ' 9-23-1984',
      13.435203,
      9,
      ' 4-15-1976',
      0,
      2.590438,
      ' 0- 2-1991',
      2,
      0,
      19.463164,
      ' 2-18-1988',
      44,
      3,
      6,
      ' 7-11-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4);
commit;
end;
/


