set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2044',
      NULL,
      '13431034',
      '20423013',
      '31341323',
      NULL,
      '24324024',
      '04012103',
      '10420324',
      NULL,
      '33420422',
      '24114031',
      '04141403',
      '14324300',
      '22242443',
      '12300323',
      '01443312',
      '00412131',
      '30213004',
      '12041023',
      '41334432',
      '02202310',
      '03301300',
      '30412132',
      NULL,
      '21243034',
      '34200134',
      '43033001',
      '22432104',
      '00121112',
      '01214042',
      '24223043',
      NULL,
      '42440203',
      '30342303',
      '20023111',
      '30312232',
      '40432143',
      '22131012',
      '30002220',
      '22011301',
      '44014332',
      NULL,
      NULL,
      '34043323',
      '114',
      '02',
      NULL,
      NULL,
      '3430220',
      3,
      1.144267,
      0,
      NULL,
      '102131',
      0,
      ' 5- 1-1989',
      ' 0-25-1994',
      71.375932,
      NULL,
      15.641732,
      7.346674,
      15.971988,
      5.424332,
      26,
      6.144907,
      13,
      8.087893,
      21,
      4.621338,
      8,
      11,
      18.805419,
      2,
      11,
      NULL,
      15.577415,
      10,
      1.527062,
      5.706086,
      11,
      8.490829,
      0.171547,
      22.283044,
      17,
      52,
      NULL,
      62.212656,
      NULL,
      NULL,
      NULL,
      15.423195,
      4.236606,
      29,
      51,
      20,
      '10- 6-1990',
      1.966344,
      6,
      0.896458,
      3.819073,
      3,
      2,
      1,
      6,
      0,
      0.294037,
      NULL,
      0.185269,
      1.532543,
      NULL,
      NULL,
      1.036600,
      1,
      1,
      1,
      1.944751,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-25-1994',
      54,
      46,
      28,
      2,
      21.942537,
      5,
      ' 6- 2-1994',
      0,
      0.450978,
      144.616796,
      0.367546,
      NULL,
      9.411223,
      0,
      1.092209,
      23,
      NULL,
      NULL,
      NULL,
      ' 8-23-1987',
      15.094485,
      30,
      10.353200,
      38.777610,
      NULL,
      41.372840,
      NULL,
      13,
      33.124175,
      51,
      57.487837,
      67,
      NULL,
      6.938118,
      13,
      5.403948,
      31.019488,
      52.932527,
      17.241516,
      6.780806,
      ' 0-12-1984',
      5,
      6,
      '10-11-1976',
      7,
      6.630642,
      2.472096,
      4,
      20,
      3,
      0,
      1.027820,
      NULL,
      NULL,
      1.112355,
      0,
      10.475482,
      11.369477,
      0,
      16.842144,
      0.822658,
      0.843424,
      ' 5- 3-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      NULL,
      ' 4- 3-1992',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      36,
      NULL,
      5.666411,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '11-28-1981',
      NULL,
      NULL,
      NULL,
      1,
      3,
      7.268151,
      NULL,
      NULL,
      4,
      5.026482,
      '11-27-1982',
      1,
      65.570968,
      NULL,
      5.334470,
      53.816239,
      NULL,
      46,
      ' 1-13-1999',
      26.174611,
      1.084061,
      32.560043,
      ' 6- 8-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


