set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '1',
      '2',
      '1',
      NULL,
      '4',
      NULL,
      NULL,
      '3',
      '3',
      '3',
      NULL,
      '4',
      '1',
      '0',
      NULL,
      '2',
      '1',
      '0',
      '1',
      NULL,
      '2',
      '3',
      '',
      NULL,
      '',
      '1',
      '4',
      '4',
      '2',
      '4',
      NULL,
      '',
      NULL,
      '4',
      '2',
      '1',
      NULL,
      '1',
      '2',
      '3',
      NULL,
      '1',
      '4',
      NULL,
      '32411440',
      12,
      6,
      '1014240',
      3,
      98.654867,
      2,
      NULL,
      '241230',
      6,
      ' 4- 3-1978',
      '11-13-1985',
      70,
      42,
      17.619180,
      9,
      16.072917,
      11,
      24,
      NULL,
      NULL,
      4.826389,
      23,
      10,
      9,
      NULL,
      1.505134,
      9.241311,
      1.511586,
      NULL,
      1.024036,
      11,
      13.679515,
      7,
      14,
      8.566174,
      1.640478,
      54.250458,
      88,
      49.650435,
      55,
      25.426610,
      75,
      NULL,
      1.482335,
      9.402358,
      12,
      12.943572,
      52.341688,
      102,
      ' 2- 9-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.819380,
      1.575297,
      14,
      NULL,
      0.995862,
      4,
      '11-10-1995',
      NULL,
      1.551014,
      NULL,
      1,
      0,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 8-1977',
      32.293794,
      39.769215,
      63.102223,
      80.136871,
      1,
      20,
      28,
      28.733200,
      56.903524,
      32.485583,
      8.880661,
      43,
      ' 3- 9-1995',
      19,
      13.665712,
      15,
      NULL,
      45.377738,
      70,
      11.567869,
      ' 5-16-1983',
      0.137512,
      1.442031,
      NULL,
      0,
      9.916478,
      2.341305,
      NULL,
      6,
      0.735291,
      1.626276,
      0,
      0,
      42,
      0,
      1,
      6,
      NULL,
      5.636210,
      1.452675,
      NULL,
      0.212508,
      '11-16-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      9.120134,
      24.830798,
      '10- 8-1990',
      NULL,
      NULL,
      NULL,
      23,
      ' 4- 2-1997',
      27.023382,
      ' 4- 9-2000',
      5,
      5.246517,
      ' 4-23-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      94,
      ' 5-27-1988',
      7,
      42,
      19.817401,
      37,
      ' 2- 5-1980',
      5.818589,
      1,
      3,
      ' 6-18-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


