set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      '1',
      '0',
      '3',
      '2',
      '2',
      '1',
      '2',
      '2',
      NULL,
      '4',
      '2',
      '1',
      NULL,
      '1',
      '0',
      NULL,
      '3',
      NULL,
      '1',
      NULL,
      '2',
      '1',
      '',
      '4',
      NULL,
      NULL,
      '1',
      '4',
      '1',
      NULL,
      '',
      '',
      '0',
      '3',
      '4',
      '3',
      NULL,
      NULL,
      '4',
      '3',
      '2',
      '0',
      '2',
      '044',
      '0',
      NULL,
      20,
      '4340444',
      2.164373,
      29.420875,
      0,
      1,
      '333423',
      5,
      NULL,
      ' 3-26-1976',
      68,
      172,
      NULL,
      8,
      16,
      10.268426,
      12.852204,
      0,
      4.876207,
      0,
      7,
      5.396258,
      17,
      NULL,
      6.048005,
      2.641757,
      16.334591,
      2.624626,
      30.096008,
      4,
      21.294774,
      0,
      63.301555,
      7,
      1.611201,
      34.814764,
      67,
      25,
      126.968567,
      57,
      63.278839,
      ' 1-29-1996',
      16.125059,
      8.047763,
      NULL,
      7,
      133,
      23.537903,
      '11- 0-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      6.264757,
      1,
      ' 2-16-2003',
      1,
      1,
      31,
      0.009784,
      3,
      68,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-15-1978',
      19.563552,
      52,
      18.388801,
      36.978117,
      45,
      NULL,
      63.348525,
      48.462568,
      NULL,
      45,
      64,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      21.222882,
      56.973545,
      5.041527,
      5,
      NULL,
      10,
      0,
      ' 2- 6-1992',
      4,
      7.262268,
      1.385422,
      NULL,
      11.463027,
      0.762783,
      1.161999,
      9,
      NULL,
      11.342095,
      NULL,
      0,
      1,
      13,
      7,
      13,
      1,
      0.256155,
      ' 8-28-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      42,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      4.356832,
      NULL,
      30.136136,
      ' 9-10-1986',
      5.537749,
      6.082830,
      '10-18-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      ' 5-22-1994',
      NULL,
      16.554382,
      14,
      NULL,
      2,
      9,
      '10-19-1981',
      NULL,
      187,
      NULL,
      0,
      ' 3- 0-1985',
      44.939417,
      0.892343,
      NULL,
      ' 7-23-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


