set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8013776';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0303',
      '40311433',
      '14313124',
      '13024420',
      NULL,
      '02332344',
      '13020112',
      '02434401',
      '21420110',
      NULL,
      '22004011',
      NULL,
      '02104332',
      '12410034',
      '31041242',
      NULL,
      NULL,
      '24234322',
      NULL,
      '00334433',
      '14401324',
      NULL,
      '34141403',
      '24342401',
      NULL,
      '01142344',
      '10003441',
      NULL,
      '22243242',
      NULL,
      '40241422',
      '22212324',
      '11344240',
      '04202034',
      '21222320',
      NULL,
      NULL,
      NULL,
      '13223014',
      NULL,
      '44212344',
      NULL,
      '20103002',
      '20342142',
      '43342312',
      NULL,
      '33',
      NULL,
      NULL,
      '2330124',
      2,
      0.036502,
      3,
      NULL,
      '333444',
      5,
      '11- 8-2002',
      '11- 8-1995',
      18.698001,
      NULL,
      NULL,
      3.411523,
      NULL,
      20,
      72.558599,
      NULL,
      NULL,
      16.219283,
      8.435687,
      23,
      NULL,
      17,
      3.546651,
      9.812624,
      30.890201,
      NULL,
      52,
      8.474791,
      NULL,
      16,
      99,
      6.873702,
      0.051203,
      151,
      NULL,
      36.692205,
      58.937655,
      120.512372,
      22.084040,
      '11- 5-1998',
      NULL,
      32,
      22.451291,
      37.166747,
      NULL,
      NULL,
      ' 4-12-1997',
      0.263381,
      4,
      0,
      1,
      1.436551,
      NULL,
      1,
      0,
      1,
      1,
      4.780128,
      NULL,
      1.845024,
      0,
      NULL,
      1,
      0.766576,
      1.101443,
      0.277846,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-29-1982',
      27.776916,
      45,
      13,
      16.093425,
      6,
      5.372893,
      ' 1-22-1988',
      NULL,
      0.520779,
      186,
      NULL,
      1,
      187,
      0.264228,
      NULL,
      22,
      1,
      NULL,
      118.414968,
      ' 7- 7-1986',
      50,
      NULL,
      61,
      84,
      82.231602,
      84.773312,
      23,
      79,
      45.690234,
      32.158493,
      30.323197,
      21,
      '10-10-1994',
      NULL,
      2.771338,
      19.488922,
      44.855940,
      77.264695,
      135.093470,
      9.335855,
      ' 4-12-1983',
      25.021139,
      NULL,
      ' 6-22-1975',
      14,
      7.302307,
      17.575595,
      17,
      5.393549,
      11.889039,
      0,
      17,
      1,
      66.495619,
      1,
      NULL,
      9.660124,
      7.018304,
      1,
      1,
      1.544228,
      0,
      ' 1-21-1983',
      1,
      3.714014,
      2,
      '11-10-1995',
      86,
      NULL,
      ' 2- 2-1998',
      21,
      4.064918,
      ' 5-24-1990',
      NULL,
      ' 3-18-1983',
      NULL,
      ' 3- 3-1995',
      18.864860,
      17,
      NULL,
      NULL,
      61,
      NULL,
      2.749357,
      3.743373,
      ' 5-18-2002',
      8.123435,
      11.647527,
      '10-27-1989',
      1,
      0,
      0,
      ' 3-16-2002',
      49.885905,
      2.649624,
      3.530230,
      ' 3-12-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


