set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6220814';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4120',
      '41342204',
      '30033323',
      NULL,
      '12023340',
      '44113240',
      '31441430',
      '21243202',
      NULL,
      '21331130',
      '42422023',
      NULL,
      '22314222',
      '33420101',
      '22204002',
      '23403424',
      NULL,
      '12012201',
      '42134421',
      '33342122',
      '12002210',
      NULL,
      NULL,
      NULL,
      '12214202',
      '01132320',
      '04002322',
      '33331100',
      '04311012',
      '24242144',
      '42312344',
      '44202123',
      '02013331',
      '31000400',
      NULL,
      '10101232',
      '02001121',
      NULL,
      '23140223',
      NULL,
      '04440013',
      '04413243',
      '30210212',
      '03321314',
      '24404144',
      '130',
      '02',
      NULL,
      NULL,
      '3032042',
      NULL,
      1.587929,
      2,
      NULL,
      '404141',
      NULL,
      ' 0-14-1987',
      NULL,
      NULL,
      NULL,
      39,
      8.895772,
      16.877684,
      12,
      26,
      17,
      11.535072,
      12,
      NULL,
      6,
      29.022369,
      NULL,
      28,
      16.187493,
      28,
      1.068667,
      40,
      15.860832,
      16.617290,
      19.860225,
      29.751633,
      16,
      1.585573,
      6,
      20,
      NULL,
      154,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      11.326008,
      NULL,
      NULL,
      196.316050,
      '11-25-1977',
      0.120954,
      2.148607,
      NULL,
      NULL,
      NULL,
      0.644111,
      0.408920,
      NULL,
      0,
      1,
      3.084107,
      1,
      NULL,
      2,
      0.258282,
      1.119838,
      1.102116,
      1,
      1,
      3.192491,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-13-1979',
      25,
      34,
      9.497475,
      0,
      6.251544,
      2.282678,
      ' 5-10-1981',
      0.530727,
      1.481238,
      153.917462,
      0.543307,
      2,
      56,
      0.272891,
      1,
      33,
      NULL,
      NULL,
      NULL,
      NULL,
      101,
      37.529072,
      NULL,
      20.473798,
      95,
      29.603136,
      79,
      42,
      23.822484,
      NULL,
      15,
      NULL,
      NULL,
      3,
      1,
      17.748385,
      12.764446,
      70.027414,
      NULL,
      NULL,
      NULL,
      1.919931,
      NULL,
      NULL,
      9.682165,
      11.185638,
      3,
      2.613043,
      0.023547,
      0.648086,
      0,
      11.412612,
      1,
      47.082853,
      1,
      6,
      NULL,
      17,
      0,
      4,
      0,
      0.785164,
      ' 7- 0-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.209211,
      ' 2- 1-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39.910735,
      ' 1-25-1997',
      2,
      2,
      ' 1-20-1999',
      28,
      20.121720,
      ' 1- 4-1990',
      0,
      NULL,
      ' 7- 6-2000',
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      ' 8- 0-2003',
      37.010966,
      17.585206,
      7.031826,
      ' 8-23-1989',
      1.598120,
      38.886345,
      '10-19-1991',
      6,
      129.026367,
      17,
      48.556382,
      NULL,
      NULL,
      1,
      NULL,
      ' 2- 8-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


