set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6220814';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2234',
      '20331144',
      '41444300',
      '40414442',
      '44420021',
      '34133101',
      '43034323',
      '23342202',
      '10313113',
      '11300313',
      '31242314',
      NULL,
      '34124411',
      '22224202',
      '20144410',
      '41320303',
      '02301441',
      '10322122',
      '22110020',
      '31123034',
      '31330414',
      '02024431',
      NULL,
      '13311104',
      '12143113',
      NULL,
      '12022244',
      '41132221',
      NULL,
      '11112212',
      '14102434',
      '31422001',
      '20200401',
      NULL,
      NULL,
      '32421040',
      '21033442',
      NULL,
      NULL,
      NULL,
      NULL,
      '24331032',
      '21134333',
      '01434332',
      '13212324',
      '343',
      '23',
      12,
      NULL,
      '2400230',
      2,
      38.735162,
      NULL,
      NULL,
      '032324',
      5.485459,
      ' 3- 0-1986',
      NULL,
      NULL,
      10.735796,
      0,
      10.012254,
      8,
      5,
      11,
      10.398056,
      13.084359,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      24,
      10,
      25,
      22,
      27,
      NULL,
      13.895183,
      0.006391,
      NULL,
      12,
      0.423385,
      81,
      150.476644,
      48,
      175.632545,
      81,
      138,
      ' 4- 2-1976',
      37.488450,
      0,
      5.548953,
      33,
      1.792024,
      118,
      ' 7-13-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      24.715763,
      19.474962,
      26.597325,
      15,
      1,
      '10-22-1996',
      1,
      0.024821,
      30,
      1,
      NULL,
      88,
      0,
      1,
      52.616524,
      NULL,
      NULL,
      NULL,
      ' 9- 7-1981',
      88,
      69.615503,
      45,
      NULL,
      47,
      15,
      45.220522,
      NULL,
      20.092397,
      32,
      18,
      8.393341,
      ' 9- 9-1985',
      15.609136,
      1,
      12.525393,
      NULL,
      34,
      25.556050,
      7.870808,
      '11- 6-1986',
      NULL,
      0.414726,
      NULL,
      8,
      NULL,
      7,
      NULL,
      9,
      7.522160,
      1,
      3,
      NULL,
      NULL,
      1.316247,
      1.762693,
      10.771394,
      NULL,
      NULL,
      NULL,
      3.391210,
      1.047669,
      ' 4-27-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 5-1974',
      NULL,
      NULL,
      NULL,
      32.296321,
      ' 3-11-1990',
      36.757634,
      '11- 0-1995',
      NULL,
      NULL,
      ' 1- 8-1999',
      12,
      17.959225,
      ' 9- 8-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      19.933228,
      NULL,
      NULL,
      3,
      10.454296,
      ' 7- 7-1999',
      1.596764,
      25,
      ' 1-14-1990',
      4.691072,
      36,
      8,
      3,
      ' 2-15-1984',
      NULL,
      1.862166,
      92.084570,
      ' 3- 6-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


