set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6220814';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      '4',
      NULL,
      '2',
      '0',
      NULL,
      '0',
      '0',
      '1',
      '4',
      '1',
      NULL,
      '0',
      NULL,
      NULL,
      '3',
      '1',
      '',
      '3',
      NULL,
      '3',
      NULL,
      '0',
      '4',
      '0',
      '',
      '',
      NULL,
      '2',
      '3',
      '3',
      NULL,
      '0',
      NULL,
      '1',
      '4',
      '0',
      '0',
      NULL,
      NULL,
      15.136426,
      36,
      NULL,
      0.968058,
      89,
      2,
      NULL,
      NULL,
      NULL,
      ' 1- 0-1989',
      ' 2-25-1987',
      11,
      234,
      9,
      NULL,
      8,
      6.634514,
      54.222805,
      10,
      0.318581,
      14,
      8.415270,
      6,
      22,
      14.585880,
      6.196444,
      22.349742,
      NULL,
      25,
      14.211422,
      7.114362,
      17.318197,
      19.929877,
      73.747433,
      NULL,
      1.131408,
      2,
      90.762736,
      63.579051,
      NULL,
      196.116780,
      173.138660,
      ' 5-17-1986',
      45.210825,
      NULL,
      10.013546,
      35,
      133,
      67.076869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      3.965234,
      7.041101,
      '10-20-1992',
      0.551055,
      1.865003,
      NULL,
      0.077793,
      NULL,
      NULL,
      NULL,
      1.374897,
      35,
      NULL,
      NULL,
      NULL,
      NULL,
      105.725763,
      14,
      22,
      39,
      53,
      21.630584,
      31.104256,
      30.039888,
      25.114277,
      65.549816,
      NULL,
      43.711232,
      ' 0- 9-1982',
      NULL,
      NULL,
      10,
      25.162066,
      33.500934,
      7.862170,
      NULL,
      NULL,
      16,
      20.840977,
      ' 3-19-1997',
      2.103168,
      16,
      11.431114,
      NULL,
      2,
      0.372411,
      0,
      NULL,
      0,
      62.086672,
      1,
      1.766651,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      1.317786,
      ' 7-25-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      2.450524,
      2,
      ' 4- 1-1983',
      NULL,
      NULL,
      NULL,
      30,
      ' 8-17-2000',
      27,
      ' 5- 9-2003',
      10,
      NULL,
      ' 8-10-1997',
      24.422578,
      12,
      ' 6- 6-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.879804,
      ' 4- 2-2000',
      70,
      13,
      11.275938,
      ' 4-25-1996',
      1,
      11.492766,
      ' 6-20-2001',
      12,
      48.565327,
      2.131477,
      93,
      ' 2- 1-1978',
      47.253326,
      1,
      73,
      '10-21-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


