set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6220814';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      '3',
      NULL,
      '1',
      '2',
      '0',
      '2',
      '2',
      '1',
      NULL,
      '0',
      '3',
      NULL,
      '1',
      '0',
      '3',
      '1',
      '3',
      NULL,
      '2',
      '',
      '2',
      '4',
      '3',
      '2',
      '4',
      NULL,
      '',
      '3',
      '4',
      NULL,
      '3',
      '3',
      '2',
      '1',
      '1',
      '3',
      NULL,
      NULL,
      '210',
      '12100330',
      48.109012,
      29,
      '2121032',
      1.942558,
      205,
      2,
      1,
      '222034',
      1.265705,
      ' 0- 8-2003',
      ' 2-27-1995',
      27.800792,
      43,
      0.732498,
      NULL,
      8.605151,
      1.760842,
      NULL,
      NULL,
      1,
      12.196570,
      16,
      9.342212,
      5.457028,
      13.495682,
      9.786469,
      20,
      35,
      34,
      NULL,
      18,
      37.665369,
      8,
      NULL,
      5.100599,
      2.425318,
      41.694761,
      154.162605,
      11.745129,
      114.559324,
      98.728951,
      112,
      ' 8-13-1993',
      22.947308,
      32,
      22,
      6.504125,
      120.636749,
      178.415831,
      ' 8-17-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      56,
      11.617764,
      16.749502,
      25,
      1.974371,
      ' 8-10-2000',
      0,
      0.858852,
      40.395491,
      NULL,
      0.469023,
      NULL,
      NULL,
      1.796081,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      87.133276,
      NULL,
      82,
      60,
      NULL,
      NULL,
      91,
      NULL,
      71,
      49,
      37,
      NULL,
      ' 3- 5-1989',
      8.713653,
      4,
      1,
      12.304150,
      45.728599,
      3.821385,
      NULL,
      ' 6-25-1992',
      3,
      28,
      ' 7-28-1990',
      10.914295,
      4.419597,
      10.361730,
      NULL,
      6,
      5,
      1,
      13.839800,
      0,
      74,
      0.309804,
      0.074661,
      9,
      26.028759,
      0,
      0.397377,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      173,
      NULL,
      ' 6-23-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-13-1984',
      NULL,
      NULL,
      NULL,
      5,
      ' 1-25-1996',
      106.168953,
      NULL,
      ' 7-25-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6,
      NULL,
      62,
      18.385273,
      24.197810,
      ' 3- 6-1991',
      NULL,
      NULL,
      NULL,
      13.009217,
      48.479568,
      1,
      22,
      ' 0- 6-1994',
      36,
      0.330694,
      107,
      ' 9-21-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


