set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8218619';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2214',
      '11213114',
      NULL,
      '34434442',
      '01024332',
      '02124312',
      '31402210',
      NULL,
      '40400230',
      '30033142',
      '10044200',
      '03424220',
      '33144444',
      '10140130',
      '30323132',
      '23343231',
      '11011240',
      NULL,
      '22001441',
      '41223430',
      '12134113',
      '20200031',
      '14021403',
      '02124011',
      '10331431',
      '40041101',
      '14030123',
      '43301240',
      NULL,
      '31403301',
      '11042303',
      NULL,
      '22444441',
      '42141423',
      NULL,
      '21012013',
      NULL,
      '32041041',
      '11114010',
      '33202041',
      '03134344',
      NULL,
      '20234013',
      '23412202',
      '33341121',
      NULL,
      '00',
      7.317194,
      9,
      '4034004',
      NULL,
      1.268544,
      NULL,
      NULL,
      '440343',
      NULL,
      ' 9- 7-1998',
      ' 5-16-1975',
      64,
      40.358792,
      20.109359,
      14.543558,
      15,
      19.897557,
      96,
      20,
      4.513920,
      13.205858,
      7.221993,
      24,
      34.924277,
      0.485379,
      NULL,
      21,
      NULL,
      4,
      8,
      4,
      18.513027,
      7.729417,
      81.109775,
      13.346971,
      0,
      NULL,
      172,
      109.394234,
      164.801979,
      58,
      NULL,
      ' 4-17-1990',
      32,
      31.201054,
      NULL,
      39,
      163,
      235.207689,
      ' 5-29-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      106,
      NULL,
      9,
      NULL,
      9.350398,
      10.211318,
      ' 3- 9-1995',
      0,
      0.909589,
      171.915726,
      1.632656,
      NULL,
      85,
      0,
      0,
      0.767581,
      NULL,
      NULL,
      NULL,
      ' 6- 9-2003',
      15.224173,
      27.080942,
      72.372195,
      87,
      21.380514,
      22,
      75,
      51,
      NULL,
      NULL,
      2,
      NULL,
      '11-26-2003',
      3,
      15.084944,
      NULL,
      67.172978,
      85.390428,
      8.992245,
      6.835187,
      ' 2- 8-1975',
      2,
      17,
      ' 3- 1-1996',
      9.013823,
      NULL,
      NULL,
      6,
      30.690785,
      2,
      1,
      11,
      NULL,
      38,
      1,
      1,
      9.528426,
      25.746113,
      0,
      1.199068,
      1.368067,
      1.065921,
      ' 2-24-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      270.738063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 2-1993',
      35,
      NULL,
      3,
      NULL,
      ' 8-10-1991',
      64,
      47.325530,
      ' 1-19-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      18.973083,
      ' 4-17-2001',
      NULL,
      12.562908,
      34,
      NULL,
      NULL,
      6.936251,
      ' 8- 7-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


