set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9229226';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2201',
      '14330044',
      '20444010',
      '24340423',
      '03122203',
      '44434103',
      '12104110',
      '22032103',
      '20422323',
      '11320100',
      '11112311',
      '12341411',
      NULL,
      '21330123',
      '11304001',
      NULL,
      '11402423',
      '02243034',
      '44031310',
      '22103210',
      '00342113',
      '31041133',
      '34023042',
      '31040203',
      '34020313',
      '44122440',
      NULL,
      '32103041',
      '41141104',
      '31001143',
      '20243201',
      NULL,
      '21220142',
      '43323240',
      '14331431',
      '42401312',
      '01143320',
      '24210324',
      NULL,
      NULL,
      '43210212',
      '42240013',
      '21311012',
      '22033222',
      '32221102',
      '131',
      '00',
      NULL,
      NULL,
      NULL,
      NULL,
      0.508164,
      1,
      NULL,
      '124433',
      3,
      ' 4-16-1978',
      ' 2-29-1998',
      51.464291,
      NULL,
      15.142414,
      NULL,
      14.992996,
      18.819007,
      41.819645,
      4.441675,
      16.000228,
      6.532942,
      14,
      13,
      17,
      0,
      NULL,
      11,
      9,
      13.594010,
      NULL,
      NULL,
      0.068605,
      4.432606,
      NULL,
      19.588865,
      NULL,
      60.225622,
      34.011321,
      35,
      NULL,
      NULL,
      35,
      NULL,
      NULL,
      21,
      5,
      31.713516,
      14,
      103.324658,
      ' 5- 1-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54,
      35.822888,
      NULL,
      9,
      13,
      2.830989,
      ' 3-28-1976',
      1,
      1.499468,
      5,
      0,
      1,
      125,
      1.879071,
      NULL,
      76.528428,
      NULL,
      NULL,
      NULL,
      NULL,
      44.570270,
      NULL,
      NULL,
      NULL,
      52.681827,
      NULL,
      22.059007,
      69.669989,
      NULL,
      45,
      35,
      95.955595,
      NULL,
      3.472965,
      7.355179,
      NULL,
      57.919151,
      39,
      49,
      NULL,
      ' 6- 0-1977',
      4.476399,
      12.506210,
      ' 1-25-1976',
      9,
      0,
      4,
      5,
      17,
      5.526601,
      0.239787,
      NULL,
      1,
      80,
      1,
      11,
      5,
      19.297201,
      4,
      NULL,
      6.988730,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37.754743,
      2.565990,
      ' 7-10-1980',
      NULL,
      NULL,
      NULL,
      52,
      NULL,
      18,
      ' 9-25-1985',
      13,
      NULL,
      ' 6-25-1980',
      51.626791,
      78.948680,
      '10-17-1975',
      1.910070,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      6,
      ' 2-12-1976',
      NULL,
      NULL,
      27.169573,
      ' 2-26-1978',
      1,
      35,
      NULL,
      10.226866,
      152,
      NULL,
      39.942871,
      NULL,
      6,
      1.514699,
      171.238635,
      ' 4- 5-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


