set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027574';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4444',
      '32122331',
      '13240010',
      '20041224',
      '34021311',
      '34344232',
      '12410040',
      '44121323',
      '42020344',
      '43221041',
      '20204232',
      '11410100',
      '11331030',
      '32220230',
      NULL,
      '40200243',
      NULL,
      '21310431',
      '03343134',
      '24140042',
      '42340323',
      '43304431',
      NULL,
      NULL,
      '32200214',
      '12133423',
      '43132202',
      '13143043',
      '00233102',
      '30432034',
      '21234432',
      '24332212',
      '31013034',
      NULL,
      '40311042',
      NULL,
      '24134332',
      '00433003',
      '04424303',
      '32010004',
      '24330024',
      '43122440',
      '21232323',
      '13004320',
      '34323220',
      '',
      '',
      NULL,
      NULL,
      '4020331',
      2,
      1,
      0,
      NULL,
      '102440',
      0,
      NULL,
      '11-17-1990',
      101,
      NULL,
      3.969032,
      1.663904,
      2.161665,
      12.850533,
      68.411506,
      3.665262,
      3.554303,
      NULL,
      19.648564,
      NULL,
      12.637628,
      NULL,
      11.139093,
      9,
      NULL,
      NULL,
      23,
      1,
      40,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      127,
      NULL,
      144.324050,
      136,
      191.139040,
      ' 3-10-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.525179,
      0.060114,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.374658,
      1,
      NULL,
      0,
      0,
      0.316581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 0-1989',
      NULL,
      NULL,
      7,
      4,
      10.122725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-22-1980',
      NULL,
      41,
      NULL,
      62,
      91.000835,
      76.211832,
      NULL,
      140,
      107,
      NULL,
      140,
      NULL,
      '10- 8-1993',
      7.081475,
      8,
      7.871104,
      NULL,
      16.892978,
      68.158905,
      8,
      NULL,
      NULL,
      9.864864,
      NULL,
      NULL,
      9.334555,
      NULL,
      NULL,
      3.648672,
      1,
      NULL,
      8.872476,
      NULL,
      52.558715,
      0.704720,
      3,
      19.893153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 6-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      65.755393,
      NULL,
      46.024511,
      ' 0-28-1992',
      5.757445,
      124.566798,
      ' 6- 8-1981',
      15.359942,
      26.409597,
      0.023727,
      27.912474,
      ' 7- 0-1979',
      23.420981,
      1,
      331.398631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.225587,
      103,
      41.415071,
      78.775883,
      46,
      1.588768,
      1,
      4,
      NULL,
      2,
      NULL,
      0.038644,
      0.656687,
      22.965113,
      NULL,
      NULL,
      NULL,
      NULL,
      3.731216,
      NULL,
      0.314888,
      0,
      239.356534,
      33,
      3.758114,
      22,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.700085,
      0,
      1,
      NULL,
      107,
      97.588681,
      20,
      15.200736,
      26,
      1,
      0,
      27,
      1.421593,
      0,
      1,
      NULL,
      0.116130,
      25,
      0,
      47.343612,
      NULL,
      NULL,
      NULL,
      12,
      7.466422,
      22.730552,
      3.533870,
      47.067072,
      18.566801,
      NULL,
      NULL,
      0.085209,
      1.980460,
      1,
      0,
      0,
      1,
      1,
      7,
      ' 8-16-1978',
      ' 4-23-1980',
      ' 0- 3-1984',
      ' 0-16-1979',
      '10-22-1986',
      ' 3-15-1978',
      ' 6-22-1977',
      NULL);
commit;
end;
/


