set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027574';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4424',
      '01343324',
      '20434244',
      '01142243',
      '10123000',
      '01434233',
      '43023433',
      NULL,
      NULL,
      '01040100',
      '10114010',
      '03131241',
      '34122312',
      '33210311',
      '02314024',
      '02241300',
      '23212441',
      '10332102',
      NULL,
      '43411124',
      '24324303',
      NULL,
      '22300322',
      '12223244',
      '42024442',
      '00334323',
      '34421101',
      '04140304',
      '00233134',
      NULL,
      '14321322',
      '13344031',
      '31243234',
      '20131040',
      '40434130',
      '40242343',
      '20311021',
      '00300424',
      '03314334',
      '41230003',
      '12004411',
      '01313401',
      '00342223',
      '03104124',
      '43214421',
      '223',
      '34',
      NULL,
      NULL,
      '4330244',
      2.369418,
      2.371905,
      NULL,
      NULL,
      '433222',
      NULL,
      ' 4- 5-1998',
      ' 6- 1-1992',
      NULL,
      NULL,
      NULL,
      17.876559,
      32,
      13,
      NULL,
      8,
      16,
      15,
      35.204341,
      17.114562,
      21,
      17,
      NULL,
      5.076023,
      NULL,
      9.375595,
      NULL,
      NULL,
      13.869341,
      17.486602,
      NULL,
      10.060331,
      2.047897,
      49,
      182.665349,
      92,
      132.760465,
      166.814112,
      26.386675,
      ' 0-23-1987',
      NULL,
      8,
      NULL,
      8.131365,
      48,
      23.207255,
      ' 1-26-1981',
      2.308413,
      1.756882,
      1.517925,
      NULL,
      0.319566,
      0,
      9,
      0.266036,
      0.704265,
      1,
      0,
      1.272084,
      NULL,
      NULL,
      1.685661,
      0.451006,
      7,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-28-1984',
      116,
      2.673080,
      2.511257,
      3.437681,
      1,
      NULL,
      NULL,
      0.782647,
      0.660401,
      139,
      0.572429,
      1,
      90,
      0,
      0.350733,
      56.259684,
      0.580228,
      1.188054,
      77,
      ' 9-25-1991',
      0,
      138.067327,
      NULL,
      NULL,
      1.353919,
      118,
      105.349171,
      19,
      NULL,
      70,
      2.432720,
      14,
      ' 9-12-1982',
      NULL,
      4,
      6,
      3.314301,
      1,
      35.566559,
      0.263246,
      NULL,
      NULL,
      7,
      '11- 1-1976',
      7.613144,
      15.167619,
      10,
      NULL,
      3,
      2,
      1,
      11.672176,
      0,
      28.732234,
      NULL,
      0.124356,
      5.280338,
      8,
      1.804988,
      4.043234,
      7,
      0,
      NULL,
      3,
      0.949061,
      1.980228,
      '10-28-1991',
      147.541694,
      12.976564,
      ' 0- 6-1993',
      NULL,
      NULL,
      NULL,
      36.767900,
      NULL,
      4.155897,
      '10- 8-2003',
      NULL,
      7,
      '11- 2-1995',
      65,
      30,
      '11-11-1974',
      0.138311,
      2,
      '10-12-1977',
      1.029606,
      NULL,
      ' 7-11-2002',
      1,
      NULL,
      2.614028,
      ' 9-10-1979',
      11.700855,
      5.480180,
      42,
      ' 5-29-1999',
      NULL,
      124,
      NULL,
      NULL,
      18.411624,
      20,
      29.725732,
      NULL,
      40.509414,
      0,
      106.607692,
      ' 7-20-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.505803);
commit;
end;
/


