set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027574';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2031',
      '20330220',
      '14032141',
      '14310330',
      '41010212',
      '34311203',
      '21204340',
      NULL,
      '34131442',
      '22323232',
      '03403032',
      '12030344',
      '04123134',
      '33412131',
      '40333144',
      '20421413',
      '10412414',
      '10303440',
      '00121240',
      '40000031',
      '01321031',
      '34213443',
      '11102022',
      '04141433',
      '24210340',
      NULL,
      '34443011',
      '22410233',
      '22340014',
      NULL,
      '20411244',
      NULL,
      '32031424',
      NULL,
      '42033330',
      '43301230',
      NULL,
      NULL,
      '20412244',
      NULL,
      '11221403',
      '03433221',
      '12440313',
      '34330423',
      '41114234',
      NULL,
      NULL,
      NULL,
      NULL,
      '0330432',
      0,
      NULL,
      NULL,
      NULL,
      '340232',
      0.927049,
      ' 6-19-1983',
      ' 0-12-1985',
      NULL,
      NULL,
      16,
      10.814670,
      29.908747,
      NULL,
      44.271381,
      NULL,
      NULL,
      1.251436,
      18,
      2,
      6,
      16.393232,
      NULL,
      15,
      25,
      21.013699,
      27,
      7,
      19.924862,
      17,
      NULL,
      17.270103,
      1.516015,
      61.789900,
      117,
      97.432106,
      136.921252,
      196,
      NULL,
      NULL,
      17.746110,
      NULL,
      21,
      6.479378,
      101.190947,
      163.404474,
      ' 1-27-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      78,
      24.659534,
      5,
      15.943131,
      5.836682,
      1,
      NULL,
      1.849184,
      1.692853,
      132,
      0.906100,
      0.660522,
      93.759868,
      0.424829,
      1.345843,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-20-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47.625721,
      81,
      21,
      NULL,
      49,
      33.317450,
      ' 8-16-2003',
      9.197602,
      14.084443,
      9.262164,
      33,
      45.042809,
      NULL,
      2.213324,
      '11-14-1995',
      20,
      NULL,
      ' 7-15-1992',
      5,
      0.786542,
      8.736855,
      NULL,
      NULL,
      2,
      2,
      5.144873,
      1.978654,
      56,
      1,
      11.583242,
      6.396944,
      NULL,
      2.797515,
      0,
      NULL,
      2,
      '10-11-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.441384,
      ' 6-27-1999',
      NULL,
      ' 6-27-1998',
      NULL,
      NULL,
      NULL,
      63.894477,
      20,
      NULL,
      NULL,
      0.373130,
      '10- 6-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      56.315348,
      27,
      14.258790,
      ' 4- 9-1984',
      0,
      NULL,
      ' 3-24-1979',
      0.164884,
      34.697170,
      5.322419,
      NULL,
      ' 3-18-1976',
      NULL,
      1.710891,
      92.159309,
      ' 2-11-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


