set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9621190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4114',
      '42200403',
      '41023133',
      '14120013',
      '13111420',
      '30202223',
      '23233004',
      '10443401',
      NULL,
      '02130022',
      '14031211',
      '22344131',
      '02031122',
      NULL,
      NULL,
      '20040012',
      '21034413',
      NULL,
      '32031433',
      '40024104',
      '11102102',
      NULL,
      '03310101',
      NULL,
      '00320024',
      '02244444',
      '10010143',
      '30044301',
      '24431304',
      NULL,
      '41222042',
      '22102102',
      '33423110',
      '33312033',
      '32010303',
      NULL,
      '42300312',
      '41140204',
      '30423242',
      '34342313',
      NULL,
      '32042402',
      '31330313',
      '24424330',
      '24324302',
      '310',
      NULL,
      26.476136,
      2,
      '2124220',
      2,
      NULL,
      2,
      NULL,
      '223230',
      0,
      ' 2- 6-2001',
      NULL,
      63,
      27,
      NULL,
      NULL,
      30,
      13.767632,
      25,
      0.336402,
      21.454691,
      21.795342,
      6.063571,
      13,
      45,
      13,
      3,
      5.154792,
      28,
      18.537627,
      53,
      11,
      8.510320,
      28.302828,
      41.579094,
      2,
      0,
      31.577887,
      100,
      46,
      66.271856,
      240.085379,
      100.243367,
      '10-24-1974',
      49,
      NULL,
      11,
      39,
      78,
      14.969862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      7,
      8.631003,
      NULL,
      ' 0-20-1984',
      1.534599,
      0,
      41,
      NULL,
      0.317918,
      17,
      1,
      0.590359,
      23,
      NULL,
      NULL,
      NULL,
      ' 7-13-1999',
      47,
      NULL,
      24.452790,
      2.092877,
      NULL,
      39.305160,
      63.451352,
      NULL,
      NULL,
      78.322138,
      11,
      38.754106,
      ' 7-22-1993',
      1.612094,
      12,
      1.795605,
      NULL,
      NULL,
      84.459391,
      0.061049,
      ' 1-15-1986',
      22,
      NULL,
      ' 8- 1-1978',
      3.716193,
      3,
      13,
      13.820588,
      25.345822,
      NULL,
      3.905083,
      NULL,
      0,
      81,
      3.925565,
      1.431767,
      5,
      4,
      5.565291,
      0.834447,
      1,
      1.108778,
      '10-18-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.060130,
      ' 4-10-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-21-1975',
      24,
      ' 1-17-1996',
      6,
      19.896709,
      ' 0-29-1996',
      NULL,
      110,
      ' 9-29-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      23.891864,
      ' 0-15-1991',
      NULL,
      19,
      41,
      '11-27-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


