set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3000',
      '03232420',
      NULL,
      '20133122',
      '10202032',
      '32304023',
      '10020001',
      '34103330',
      NULL,
      '20334041',
      '32240132',
      '21430432',
      '23203023',
      '33204400',
      '00003322',
      '04040242',
      '44424310',
      '13103343',
      '44013042',
      '10012303',
      NULL,
      '11033223',
      '32234111',
      '21403320',
      '03340403',
      '04331331',
      '24114443',
      '21230123',
      '32032334',
      '40123100',
      '30442040',
      NULL,
      '03012334',
      '24320301',
      '23223413',
      '21034104',
      '32114424',
      NULL,
      NULL,
      '22203332',
      '20303413',
      '22420412',
      '11023224',
      NULL,
      '31010404',
      '',
      '',
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      '433303',
      3.273658,
      ' 9- 8-1988',
      ' 3- 3-1978',
      12,
      NULL,
      28,
      18,
      4,
      11,
      9,
      NULL,
      2.169146,
      4.496079,
      39,
      23,
      39.279578,
      4.080675,
      3.757477,
      15,
      18,
      19.242634,
      43,
      19.123495,
      64.164754,
      NULL,
      NULL,
      NULL,
      NULL,
      45,
      171.665519,
      NULL,
      86,
      NULL,
      23,
      NULL,
      NULL,
      30,
      5,
      28.930182,
      NULL,
      199.583192,
      '11-10-1987',
      NULL,
      3,
      0,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0.931326,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 3-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-26-2000',
      52.952525,
      36.363192,
      NULL,
      NULL,
      19.305252,
      26,
      23.820880,
      7.558182,
      66,
      NULL,
      NULL,
      105,
      ' 1- 4-1984',
      4,
      20,
      1.561595,
      3,
      26,
      72,
      NULL,
      ' 4- 6-1977',
      NULL,
      15,
      NULL,
      3,
      19,
      18,
      5.900429,
      18,
      NULL,
      NULL,
      9.194319,
      NULL,
      39,
      1,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-25-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      9,
      22.390544,
      ' 3-18-1981',
      1,
      NULL,
      ' 1-11-1975',
      11.677060,
      14,
      3.050650,
      30,
      ' 9- 1-1992',
      23.546858,
      0.131547,
      47.397961,
      '10-14-1977',
      NULL,
      NULL,
      NULL,
      71,
      28,
      135,
      NULL,
      59.118542,
      29.446258,
      75,
      1.874410,
      33,
      NULL,
      1.253252,
      15.424708,
      0,
      1,
      78,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      13,
      154.605271,
      69.674363,
      18,
      39.025064,
      NULL,
      67.337876,
      1.802560,
      0,
      NULL,
      0,
      0.330011,
      1.321348,
      43,
      16.667450,
      64.119725,
      18.046709,
      37.290782,
      5,
      0.571937,
      13.166866,
      36.561324,
      0,
      7,
      0.055189,
      1,
      1,
      NULL,
      NULL,
      41,
      1.129120,
      0.225416,
      40,
      NULL,
      5.965394,
      14,
      75,
      79.938864,
      9.001897,
      8,
      6,
      14.124210,
      1,
      7,
      8.263254,
      1,
      0.287163,
      NULL,
      69,
      NULL,
      ' 4-23-1990',
      ' 5-11-1996',
      ' 9-26-1984',
      NULL,
      ' 3- 4-1994',
      ' 7-20-1987',
      NULL);
commit;
end;
/


