set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8203083';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3240',
      '44031400',
      '10204001',
      NULL,
      '24301143',
      '01442220',
      '40312103',
      NULL,
      '30020323',
      '01002302',
      '24214432',
      '21003434',
      '31244324',
      '32134112',
      '40104002',
      '40033211',
      '01343440',
      '02302140',
      '32100040',
      NULL,
      NULL,
      '03242213',
      '34311104',
      '02130121',
      '30432344',
      '23104032',
      '00343004',
      '33412040',
      '42110143',
      NULL,
      '03114211',
      NULL,
      '40023323',
      '01421444',
      '44132334',
      '41211122',
      '00334434',
      '10124444',
      '24401121',
      '33330443',
      NULL,
      NULL,
      '20243443',
      '42420230',
      '13123421',
      '',
      '',
      NULL,
      NULL,
      '1444010',
      0,
      0,
      2,
      NULL,
      '320123',
      1,
      NULL,
      ' 5-16-1995',
      NULL,
      NULL,
      16,
      10.829221,
      NULL,
      11,
      36,
      7.511707,
      15,
      NULL,
      NULL,
      0.702701,
      NULL,
      10.015783,
      15,
      3,
      NULL,
      NULL,
      35,
      13,
      21,
      6,
      33,
      7.693093,
      NULL,
      40.838276,
      110,
      44,
      104,
      NULL,
      30.850515,
      NULL,
      3.207977,
      32,
      28.006537,
      NULL,
      79,
      111.338836,
      ' 6- 7-1995',
      2.303161,
      NULL,
      11.108492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      3.791595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-10-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-25-1977',
      70.931230,
      33,
      50.346345,
      32,
      NULL,
      35,
      42,
      29.991764,
      42,
      37,
      NULL,
      15,
      ' 6- 1-1977',
      NULL,
      4.204686,
      1,
      11.728598,
      6,
      NULL,
      0.803691,
      ' 3- 6-1991',
      8.303858,
      3.995802,
      ' 0-28-1990',
      10,
      7.769040,
      NULL,
      18,
      8,
      NULL,
      NULL,
      15.363931,
      NULL,
      22.305932,
      1.845309,
      1,
      7.372677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-20-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44.556357,
      16.911522,
      10,
      ' 4-27-1998',
      1,
      265.799097,
      ' 0- 5-1993',
      10,
      78.189009,
      4.734041,
      NULL,
      ' 8-22-1992',
      NULL,
      1,
      61.996492,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      0,
      28,
      26,
      32.311445,
      1.608376,
      25,
      78.939573,
      18.643094,
      29.986329,
      NULL,
      44.110603,
      2,
      0.345473,
      14.865552,
      1,
      1.344516,
      35,
      0.787500,
      2,
      128,
      1.772707,
      0.454224,
      19.980804,
      81,
      4,
      31.052287,
      1,
      21.103960,
      0,
      0,
      1,
      1.336352,
      1.196806,
      NULL,
      16.278524,
      NULL,
      8.111233,
      11.735521,
      7.428218,
      0,
      0,
      3,
      6.615194,
      0,
      0,
      1.792526,
      4.141258,
      0.866317,
      53,
      11.897423,
      36.223505,
      0.944491,
      2,
      7.147236,
      22,
      5.351780,
      14,
      75.536092,
      79,
      5,
      NULL,
      8.359122,
      1.436261,
      NULL,
      5,
      3,
      NULL,
      0.702564,
      0.273209,
      38.679315,
      '10- 8-1975',
      ' 5- 1-1984',
      ' 5-28-1974',
      ' 8-25-1993',
      ' 0- 7-1997',
      ' 5-11-1995',
      NULL,
      NULL);
commit;
end;
/


