set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402223';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      '2',
      '1',
      '0',
      '4',
      '1',
      NULL,
      '4',
      '1',
      '2',
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      '2',
      NULL,
      '4',
      '1',
      '0',
      NULL,
      '',
      '2',
      '',
      '1',
      '2',
      '3',
      '0',
      '0',
      '',
      '',
      '2',
      '3',
      '3',
      '0',
      '0',
      NULL,
      '4',
      '2',
      '2',
      '4',
      '2',
      '202',
      '20313003',
      69,
      NULL,
      '1023311',
      0,
      1.794038,
      2,
      1,
      '320432',
      2,
      NULL,
      '10- 8-1985',
      9,
      29,
      1,
      5,
      7.554404,
      16.988831,
      NULL,
      NULL,
      NULL,
      0.348720,
      9,
      NULL,
      17.662781,
      NULL,
      5,
      7,
      8.250805,
      3,
      8,
      3,
      28,
      16,
      13,
      1.542754,
      NULL,
      NULL,
      8,
      32.908994,
      77.249007,
      NULL,
      NULL,
      '11- 3-1997',
      25.376158,
      2,
      17.224521,
      12,
      32,
      103.048833,
      '11- 8-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      20,
      0.060784,
      4.688776,
      3,
      1.121576,
      ' 9- 2-1982',
      1,
      2.584797,
      4.877571,
      1,
      1,
      67,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-13-1991',
      80.578691,
      63,
      15,
      NULL,
      NULL,
      0,
      68.362880,
      19.669965,
      68.821933,
      72,
      0,
      70.800390,
      NULL,
      4.874009,
      8.189691,
      1.073918,
      57,
      NULL,
      10.286708,
      0.039230,
      NULL,
      12,
      18,
      ' 0- 1-2001',
      10,
      4,
      4,
      NULL,
      10,
      2.466519,
      NULL,
      11,
      1,
      18,
      6,
      4.039314,
      NULL,
      10,
      3,
      0.888703,
      5.804740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      '10-13-2003',
      NULL,
      NULL,
      NULL,
      4.253883,
      ' 3-10-2000',
      NULL,
      ' 9-12-1984',
      11,
      NULL,
      ' 4- 1-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 8-11-1982',
      NULL,
      NULL,
      24.262708,
      ' 8-12-1999',
      NULL,
      NULL,
      ' 9-26-1977',
      0,
      75,
      20,
      18.608212,
      ' 9- 5-2003',
      65,
      0,
      NULL,
      ' 8-17-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


