set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7409886';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3021',
      NULL,
      '02040140',
      '31401223',
      '44004232',
      NULL,
      '21240400',
      '20131043',
      '20220422',
      '21340100',
      NULL,
      '31002113',
      '01334120',
      '41400314',
      '33302144',
      '12230332',
      '42244213',
      '33212131',
      '13303243',
      '23042121',
      NULL,
      '13123131',
      '23044321',
      NULL,
      '22344030',
      NULL,
      NULL,
      NULL,
      '33411202',
      '11234231',
      '14231301',
      NULL,
      '12114344',
      '43021011',
      '20021100',
      '10403404',
      '34002423',
      '22234102',
      '42242124',
      '03424403',
      '01043434',
      NULL,
      '32121224',
      NULL,
      '30312412',
      '133',
      '00',
      NULL,
      NULL,
      '3103042',
      2.560572,
      1,
      0,
      NULL,
      '122001',
      2.264976,
      ' 3- 3-1996',
      ' 7-26-1997',
      66.093292,
      NULL,
      48.559068,
      0,
      9,
      10.061187,
      19.196991,
      10,
      NULL,
      NULL,
      38,
      NULL,
      20,
      NULL,
      NULL,
      10,
      6.570752,
      2.110207,
      55,
      9,
      12.115075,
      2,
      33.740528,
      12,
      1.421619,
      27.735091,
      NULL,
      43,
      144,
      NULL,
      104.873194,
      ' 2-13-1977',
      NULL,
      53.963430,
      30,
      7,
      NULL,
      NULL,
      '10-17-1992',
      1.991410,
      4,
      1.970798,
      0,
      1,
      0.481393,
      NULL,
      2.888403,
      NULL,
      1.690491,
      NULL,
      NULL,
      NULL,
      NULL,
      1.845828,
      1.939786,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-19-1983',
      82.383641,
      0,
      NULL,
      7,
      5,
      10,
      '11-16-1978',
      1,
      1,
      120.431698,
      NULL,
      0,
      34.837830,
      NULL,
      NULL,
      NULL,
      0.267283,
      0,
      NULL,
      NULL,
      45.558673,
      54.811440,
      25,
      55,
      95.041336,
      53.497630,
      97.364217,
      23,
      37.754707,
      45.222290,
      NULL,
      1.940217,
      ' 7-22-1984',
      19,
      12.826536,
      6.178402,
      NULL,
      51.785115,
      23,
      3.699031,
      ' 0-10-1995',
      4,
      1,
      '10-22-1996',
      11,
      8,
      4,
      NULL,
      18,
      NULL,
      0,
      NULL,
      0.816722,
      61.229444,
      0.870941,
      1,
      3.174328,
      0.289974,
      8,
      0.373847,
      4.425680,
      NULL,
      ' 8- 7-1987',
      2,
      2,
      0,
      ' 4- 6-2002',
      94,
      2,
      ' 5-21-1990',
      NULL,
      NULL,
      NULL,
      7,
      '10- 0-1977',
      30,
      ' 0- 1-1997',
      11.716595,
      5,
      NULL,
      61.411178,
      10,
      ' 6-26-1984',
      NULL,
      10,
      ' 3-27-1987',
      0.726435,
      NULL,
      ' 8-14-1985',
      1,
      0,
      24,
      NULL,
      NULL,
      14.855714,
      26,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.076842);
commit;
end;
/


