set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905952';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0233',
      '00341302',
      '43243413',
      '22101440',
      '23403224',
      '12423332',
      '24130443',
      '22301233',
      '44434034',
      '22302343',
      '04440004',
      '00312303',
      '14434202',
      '00033141',
      '44201400',
      NULL,
      '21302434',
      '34344114',
      '10221041',
      NULL,
      '03141040',
      NULL,
      '01131300',
      NULL,
      '02412223',
      NULL,
      '12300321',
      '13443224',
      '04402302',
      '40032432',
      NULL,
      '02404141',
      '04011242',
      '43122143',
      '44134034',
      '13124214',
      NULL,
      '01342121',
      NULL,
      '24340421',
      '14044412',
      '20341311',
      NULL,
      '14232313',
      '33433214',
      '',
      '',
      NULL,
      NULL,
      '4303024',
      1,
      NULL,
      NULL,
      NULL,
      '244131',
      NULL,
      NULL,
      ' 7-18-1993',
      NULL,
      NULL,
      24,
      1.128688,
      16.406085,
      19.591485,
      NULL,
      0,
      39.251242,
      NULL,
      29.431314,
      11.478856,
      24.344325,
      NULL,
      32,
      0.383881,
      NULL,
      13.483925,
      26.724759,
      1.146867,
      70,
      NULL,
      44,
      6.725405,
      NULL,
      NULL,
      8,
      106.479382,
      56.722599,
      NULL,
      137,
      ' 7-23-1985',
      NULL,
      33,
      1.295855,
      NULL,
      NULL,
      141.198279,
      '11- 4-1975',
      0.382075,
      3.364456,
      4.158435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.383761,
      0,
      NULL,
      0.392774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-14-1991',
      97,
      65,
      NULL,
      93,
      23.757957,
      52,
      43,
      134,
      117,
      96.637200,
      72.918260,
      80,
      ' 1-11-1983',
      15.239854,
      10,
      10,
      34.268360,
      1,
      76,
      NULL,
      ' 6-15-1994',
      7,
      15.015598,
      NULL,
      6,
      13.064916,
      0.709312,
      10,
      NULL,
      7,
      NULL,
      1.937063,
      NULL,
      37,
      0,
      0,
      0.012803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 6-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40.741351,
      19.295153,
      33,
      ' 6-29-1994',
      NULL,
      50,
      NULL,
      2.145533,
      2.206227,
      17,
      55,
      ' 3-19-1980',
      23,
      2,
      162.573196,
      ' 7-20-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.368830,
      NULL,
      NULL,
      NULL,
      4,
      101,
      NULL,
      37,
      1,
      NULL,
      NULL,
      0.105682,
      36,
      0.476330,
      0.292207,
      25,
      2,
      NULL,
      87.108339,
      1,
      1,
      46.390741,
      NULL,
      2.624850,
      NULL,
      0.887010,
      NULL,
      0,
      0.733627,
      1.648284,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      9,
      0,
      0.755354,
      1,
      3,
      NULL,
      NULL,
      1.392707,
      NULL,
      NULL,
      NULL,
      0,
      1.491954,
      NULL,
      1.006323,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      3.679234,
      1,
      3,
      0.816300,
      1.532057,
      0.715872,
      1,
      NULL,
      ' 8-16-1977',
      ' 0-21-2000',
      NULL,
      NULL,
      ' 1- 3-1977',
      '10- 8-1996',
      NULL,
      NULL);
commit;
end;
/


