set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9853343';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      '1',
      '3',
      '4',
      '3',
      '3',
      '2',
      NULL,
      NULL,
      '2',
      NULL,
      '3',
      '3',
      '2',
      '2',
      '0',
      '1',
      '3',
      '4',
      '2',
      '1',
      '4',
      '2',
      '',
      NULL,
      NULL,
      '3',
      '3',
      '3',
      '0',
      '2',
      '',
      '',
      '1',
      '1',
      '3',
      '3',
      '4',
      '1',
      '3',
      '0',
      '1',
      '1',
      '2',
      NULL,
      '13430134',
      18,
      46.694256,
      '4214414',
      3,
      1,
      NULL,
      1,
      '431113',
      5,
      NULL,
      ' 3- 8-1975',
      36,
      107.839429,
      30,
      23.737119,
      12,
      18.358591,
      102.746419,
      24.930270,
      23.821819,
      3.661100,
      47,
      NULL,
      11.335236,
      18.086789,
      28.852585,
      11,
      13,
      NULL,
      2.994982,
      13.984665,
      44,
      NULL,
      86.406987,
      6.213246,
      0,
      112.440964,
      28,
      93,
      171.754717,
      143,
      184.526369,
      ' 3-19-1990',
      12.770661,
      24,
      21,
      14,
      186,
      NULL,
      ' 9-11-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.344058,
      5,
      11.921838,
      NULL,
      6.786953,
      NULL,
      ' 1-28-1989',
      0.849889,
      0.306738,
      51.797599,
      1,
      1.800870,
      127.233586,
      0.594596,
      0,
      82,
      NULL,
      NULL,
      NULL,
      ' 8-17-1974',
      8,
      50,
      34,
      5.868624,
      16.170475,
      NULL,
      11.932249,
      41,
      16,
      64,
      NULL,
      27.366416,
      ' 0- 3-1989',
      20,
      NULL,
      NULL,
      NULL,
      11.758171,
      80.877810,
      7.550753,
      '11-21-1982',
      38.438434,
      20.894568,
      NULL,
      2,
      6,
      4.283146,
      18,
      18,
      14.683635,
      NULL,
      5,
      1.437497,
      NULL,
      0.903182,
      NULL,
      19.266436,
      6.227973,
      1,
      1,
      1.793159,
      0,
      ' 0-16-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      26.120108,
      1,
      ' 3-28-1974',
      NULL,
      NULL,
      NULL,
      14,
      ' 4-20-1980',
      NULL,
      NULL,
      12.092177,
      5.707434,
      ' 1-24-1980',
      15.731514,
      86,
      ' 8- 0-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      25.234025,
      ' 7-11-1998',
      12.261145,
      6,
      NULL,
      ' 7- 0-1979',
      1.430308,
      NULL,
      ' 9- 8-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


