set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8700157';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4102',
      NULL,
      NULL,
      NULL,
      '03331040',
      '20324031',
      '01030024',
      '20214401',
      '30330342',
      NULL,
      '03243411',
      '04443321',
      '30223342',
      NULL,
      '12403030',
      NULL,
      '23223001',
      '33141040',
      '11423212',
      '24101034',
      NULL,
      NULL,
      '01233320',
      '34234313',
      '12021334',
      '00044044',
      '34022023',
      '32233031',
      '13423243',
      '33132410',
      '01303130',
      '12040001',
      '12202002',
      '42040321',
      '10130314',
      '30024222',
      '13102144',
      NULL,
      '43212432',
      '33310230',
      '14441124',
      '13223302',
      NULL,
      '23333033',
      '40200144',
      NULL,
      '42',
      NULL,
      NULL,
      '1202020',
      3,
      0,
      NULL,
      NULL,
      '310022',
      3.502847,
      '11- 7-2003',
      ' 9-19-1978',
      NULL,
      NULL,
      1,
      6.084956,
      10.220056,
      12,
      20,
      9.657309,
      16,
      17,
      21,
      5.892940,
      29.690641,
      NULL,
      12.334404,
      1,
      1,
      5.358354,
      NULL,
      NULL,
      28.760493,
      21,
      44.666121,
      9.210524,
      0,
      37.268058,
      NULL,
      61.901590,
      25.355726,
      NULL,
      NULL,
      ' 7-19-2000',
      16,
      17,
      3,
      7.456937,
      115.535210,
      187.229882,
      NULL,
      1.285381,
      2.298235,
      1,
      NULL,
      1.249870,
      2.770878,
      1,
      2.288742,
      NULL,
      1,
      0.536679,
      0,
      1,
      1,
      1.082462,
      NULL,
      0.424103,
      0,
      NULL,
      1.352534,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 6-1980',
      9.505327,
      NULL,
      9,
      9.265945,
      4.030412,
      1,
      ' 1-28-1974',
      0.945841,
      1,
      112.545008,
      3.186701,
      7,
      128.274668,
      0.225592,
      3.339861,
      13.678010,
      NULL,
      NULL,
      NULL,
      ' 9-25-1979',
      18.525696,
      26,
      NULL,
      46.084436,
      87,
      43,
      13.986962,
      71,
      55,
      49,
      67.382586,
      NULL,
      ' 4-22-2002',
      10.094590,
      11.650087,
      21.387750,
      NULL,
      73.407102,
      70,
      1.408989,
      '10-17-1985',
      16.903225,
      25.457336,
      '10- 7-1980',
      4.031541,
      11,
      1,
      NULL,
      20.603319,
      1,
      0.035057,
      11,
      1.687653,
      3,
      0,
      1,
      13,
      5,
      1,
      3,
      2,
      NULL,
      ' 9-28-1982',
      7,
      1.209430,
      NULL,
      ' 5-19-1976',
      54,
      NULL,
      ' 5-22-1986',
      17.897209,
      NULL,
      ' 2-20-1975',
      39.526206,
      ' 6-21-1985',
      NULL,
      ' 9- 7-1975',
      10.093813,
      3.118446,
      ' 7-24-1980',
      67.011422,
      NULL,
      ' 0-25-1996',
      7,
      NULL,
      ' 3-26-1977',
      NULL,
      NULL,
      NULL,
      1,
      2,
      7,
      '11-25-1980',
      39,
      10,
      NULL,
      ' 3- 5-1976',
      1,
      124,
      ' 0- 3-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11);
commit;
end;
/


