set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0243',
      '03343443',
      '33320240',
      '24440241',
      '40030044',
      NULL,
      NULL,
      '21130430',
      '13040334',
      NULL,
      '01022120',
      '31243011',
      '10001332',
      '42102340',
      '13414433',
      '01124424',
      '30202211',
      '00400400',
      '43243102',
      '42422124',
      '44333212',
      NULL,
      NULL,
      '02443213',
      '20002023',
      '34320343',
      '40433311',
      NULL,
      '41233104',
      '20213231',
      '43121410',
      '30023001',
      '34302343',
      '22300043',
      '20212034',
      '43111424',
      '13134223',
      '21331244',
      '33032442',
      '43421022',
      '40233233',
      '24421203',
      '04404442',
      '23012112',
      '32211202',
      NULL,
      '20',
      NULL,
      8.969006,
      '2022204',
      1,
      0,
      NULL,
      NULL,
      '333214',
      NULL,
      ' 0- 3-2002',
      NULL,
      81,
      80,
      NULL,
      4,
      15.591942,
      14,
      89,
      7,
      NULL,
      22.914706,
      7,
      NULL,
      28,
      2,
      12.818357,
      19.983110,
      9,
      17,
      NULL,
      25,
      57,
      NULL,
      28,
      7.899020,
      1.082479,
      87.556890,
      15.758627,
      30,
      203,
      NULL,
      NULL,
      NULL,
      4,
      24,
      22.235178,
      15,
      206.916915,
      NULL,
      ' 4-25-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55,
      NULL,
      5,
      8.431798,
      2,
      0,
      ' 7-24-1974',
      NULL,
      1,
      182.148971,
      1.028625,
      7.794122,
      38.904742,
      0,
      0.134443,
      74,
      NULL,
      NULL,
      NULL,
      ' 1-24-1992',
      39.307456,
      52.146655,
      18.164793,
      65.730819,
      83,
      7.840146,
      43.112723,
      8.270055,
      25,
      26,
      55.114712,
      NULL,
      ' 4- 6-1978',
      12.784480,
      0.379900,
      19,
      78,
      46,
      87.340283,
      NULL,
      '10-25-1998',
      7,
      3.671043,
      NULL,
      3.887040,
      NULL,
      NULL,
      0.201428,
      10.170552,
      NULL,
      0.311445,
      5,
      1.466154,
      64,
      4,
      1.586166,
      4,
      NULL,
      3,
      3.343831,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      96,
      NULL,
      ' 8-29-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-29-1991',
      22.967576,
      ' 6-26-2001',
      9,
      10.278026,
      NULL,
      44.947097,
      45.533902,
      ' 0-23-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.999193,
      NULL,
      60,
      NULL,
      NULL,
      ' 0- 1-1993',
      1.064389,
      NULL,
      ' 2-27-1999',
      1,
      21.783752,
      13,
      43.057570,
      NULL,
      49.005957,
      0.915457,
      136.111866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


