set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      '2',
      '1',
      '0',
      '0',
      '3',
      '2',
      '0',
      '1',
      '3',
      '1',
      NULL,
      '3',
      '4',
      '2',
      NULL,
      '0',
      '3',
      '4',
      '',
      NULL,
      '',
      '3',
      '3',
      '0',
      '0',
      NULL,
      '',
      '',
      '2',
      '2',
      '4',
      '2',
      '4',
      '0',
      '2',
      '0',
      '0',
      '4',
      '1',
      '203',
      '24403040',
      38.445958,
      11,
      '2034110',
      3,
      50,
      2,
      1,
      NULL,
      3,
      ' 0- 1-1974',
      NULL,
      24,
      95,
      22.579548,
      7.914369,
      24.437087,
      8.878670,
      71.981218,
      9,
      11.028733,
      NULL,
      NULL,
      15,
      10,
      1.005747,
      NULL,
      27.854049,
      29.870660,
      NULL,
      70,
      3.659116,
      NULL,
      22,
      61.429023,
      NULL,
      1.500045,
      85,
      126.280610,
      NULL,
      127,
      201,
      1,
      NULL,
      57.373034,
      42.304637,
      NULL,
      28.283526,
      96,
      207.460862,
      '10-19-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      3.042690,
      8,
      NULL,
      9.510318,
      5.388658,
      ' 3-17-1975',
      0.708227,
      NULL,
      NULL,
      NULL,
      1.672713,
      70,
      1.025021,
      0.758701,
      61.663918,
      NULL,
      NULL,
      NULL,
      '11-22-2002',
      NULL,
      94.893832,
      12,
      47.778583,
      58,
      98.051117,
      85,
      76.760366,
      40,
      25,
      11,
      NULL,
      '10-29-1983',
      17,
      NULL,
      2,
      13,
      99,
      186.305209,
      4.853591,
      ' 1- 1-1997',
      5.500887,
      2.125757,
      ' 8-17-1991',
      13.869618,
      8,
      3.376863,
      0,
      10,
      1.185099,
      1,
      9.500787,
      0.363002,
      39.858334,
      2,
      3.708387,
      4.789535,
      13,
      4,
      1.864315,
      5.603702,
      0,
      '11-12-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      214,
      0,
      ' 3-17-1996',
      NULL,
      NULL,
      NULL,
      18.931231,
      '10-12-1984',
      NULL,
      ' 8-17-1984',
      9.412876,
      11,
      NULL,
      96.059805,
      34.479335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      ' 7-27-1996',
      65.076637,
      28,
      40.073920,
      ' 0-23-2002',
      1.683453,
      75,
      '10-14-1976',
      NULL,
      36.366848,
      NULL,
      24.690304,
      ' 3-22-1999',
      14.053340,
      0.664404,
      159.538232,
      ' 9-26-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


